/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.model.ChannelMap;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.transport.IOutgoingTransport;
import org.jumpmind.symmetric.transport.internal.InternalOutgoingTransport;
import org.jumpmind.symmetric.web.IInterceptor;
import org.jumpmind.symmetric.web.IUriHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUriHandler
implements IUriHandler {
    protected ILog log = LogFactory.getLog(this.getClass());
    private String uriPattern;
    private List<IInterceptor> interceptors;
    protected IParameterService parameterService;
    private boolean enabled = true;

    public void setUriPattern(String uriPattern) {
        this.uriPattern = uriPattern;
    }

    @Override
    public String getUriPattern() {
        return this.uriPattern;
    }

    public void setInterceptors(List<IInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    @Override
    public List<IInterceptor> getInterceptors() {
        return this.interceptors;
    }

    protected IOutgoingTransport createOutgoingTransport(OutputStream outputStream, ChannelMap map) throws IOException {
        return new InternalOutgoingTransport(outputStream, map);
    }

    protected IOutgoingTransport createOutgoingTransport(OutputStream outputStream) throws IOException {
        return new InternalOutgoingTransport(outputStream, new ChannelMap());
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setParameterService(IParameterService parameterService) {
        this.parameterService = parameterService;
        this.log = LogFactory.getLog((IParameterService)parameterService);
    }
}

