/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.map;

import java.util.List;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.ext.INodeGroupExtensionPoint;
import org.jumpmind.symmetric.load.IDataLoaderContext;
import org.jumpmind.symmetric.load.IDataLoaderFilter;
import org.jumpmind.symmetric.map.TableColumnValueFilter;
import org.springframework.scripting.ScriptCompilationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnDataFilters
implements IDataLoaderFilter,
INodeGroupExtensionPoint {
    final ILog log = LogFactory.getLog(this.getClass());
    private boolean autoRegister = true;
    private String[] nodeGroupIdsToApplyTo;
    List<TableColumnValueFilter> filters;
    private boolean ignoreCase = true;
    private boolean enabled = true;

    protected void filterColumnValues(IDataLoaderContext context, String[] columnValues) {
        if (this.enabled && this.filters != null) {
            for (TableColumnValueFilter filteredColumn : this.filters) {
                try {
                    if (!filteredColumn.isEnabled() || (!this.ignoreCase || !filteredColumn.getTableName().equalsIgnoreCase(context.getTableName())) && (this.ignoreCase || !filteredColumn.getTableName().equals(context.getTableName()))) continue;
                    String columnName = filteredColumn.getColumnName();
                    int index = context.getColumnIndex(columnName);
                    if (index < 0 && this.ignoreCase && (index = context.getColumnIndex(columnName = columnName.toUpperCase())) < 0) {
                        columnName = columnName.toLowerCase();
                        index = context.getColumnIndex(columnName);
                    }
                    if (index < 0) continue;
                    try {
                        columnValues[index] = filteredColumn.getFilter().filter(filteredColumn.getTableName(), filteredColumn.getColumnName(), columnValues[index], context.getContextCache());
                    }
                    catch (RuntimeException ex) {
                        Throwable causedBy = ex;
                        do {
                            if (!((causedBy = ExceptionUtils.getCause((Throwable)causedBy)) instanceof ScriptCompilationException)) continue;
                            this.log.error("Message", new Object[]{causedBy.getMessage()});
                            throw new RuntimeException(causedBy.getMessage());
                        } while (causedBy != null);
                        throw ex;
                    }
                }
                catch (RuntimeException ex) {
                    this.log.error("ColumnDataFilterError", new Object[]{filteredColumn.getColumnName(), filteredColumn.getTableName()});
                    throw ex;
                }
            }
        }
    }

    public boolean filterDelete(IDataLoaderContext context, String[] keyValues) {
        return true;
    }

    public boolean filterInsert(IDataLoaderContext context, String[] columnValues) {
        this.filterColumnValues(context, columnValues);
        return true;
    }

    public boolean filterUpdate(IDataLoaderContext context, String[] columnValues, String[] keyValues) {
        this.filterColumnValues(context, columnValues);
        return true;
    }

    public void setFilters(List<TableColumnValueFilter> filters) {
        this.filters = filters;
    }

    public boolean isAutoRegister() {
        return this.autoRegister;
    }

    public void setAutoRegister(boolean autoRegister) {
        this.autoRegister = autoRegister;
    }

    public String[] getNodeGroupIdsToApplyTo() {
        return this.nodeGroupIdsToApplyTo;
    }

    public void setNodeGroupIdsToApplyTo(String[] nodeGroupIdsToApplyTo) {
        this.nodeGroupIdsToApplyTo = nodeGroupIdsToApplyTo;
    }

    public void setNodeGroupIdToApplyTo(String nodeGroupId) {
        this.nodeGroupIdsToApplyTo = new String[]{nodeGroupId};
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

