/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.integrate;

import java.text.ParseException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jumpmind.symmetric.integrate.AbstractTextPublisherDataLoaderFilter;
import org.jumpmind.symmetric.load.IDataLoaderContext;
import org.jumpmind.symmetric.load.IDataLoaderFilter;
import org.jumpmind.symmetric.load.StatementBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplatedPublisherDataLoaderFilter
extends AbstractTextPublisherDataLoaderFilter {
    static final Log logger = LogFactory.getLog(TemplatedPublisherDataLoaderFilter.class);
    private String headerTableTemplate;
    private String footerTableTemplate;
    private String contentTableTemplate;
    private Map<String, IFormat> columnNameToDataFormatter;
    private boolean processDelete = true;
    private boolean processInsert = true;
    private boolean processUpdate = true;
    private IDataLoaderFilter dataFilter;

    @Override
    protected String addTextElementForDelete(IDataLoaderContext ctx, String[] keys) {
        if (this.dataFilter == null || this.dataFilter.filterDelete(ctx, keys)) {
            String template = null;
            if (this.processDelete && (template = this.contentTableTemplate) != null) {
                template = this.fillOutTemplate(StatementBuilder.DmlType.DELETE, template, ctx, null, keys);
            }
            return template;
        }
        return null;
    }

    @Override
    protected String addTextElementForInsert(IDataLoaderContext ctx, String[] data) {
        if (this.dataFilter == null || this.dataFilter.filterInsert(ctx, data)) {
            String template = null;
            if (this.processInsert && (template = this.contentTableTemplate) != null) {
                template = this.fillOutTemplate(StatementBuilder.DmlType.INSERT, template, ctx, data, null);
            }
            return template;
        }
        return null;
    }

    @Override
    protected String addTextElementForUpdate(IDataLoaderContext ctx, String[] data, String[] keys) {
        if (this.dataFilter == null || this.dataFilter.filterUpdate(ctx, data, keys)) {
            String template = null;
            if (this.processUpdate && (template = this.contentTableTemplate) != null) {
                template = this.fillOutTemplate(StatementBuilder.DmlType.UPDATE, template, ctx, data, keys);
            }
            return template;
        }
        return null;
    }

    @Override
    protected String addTextFooter(IDataLoaderContext ctx) {
        return this.footerTableTemplate;
    }

    @Override
    protected String addTextHeader(IDataLoaderContext ctx) {
        return this.headerTableTemplate;
    }

    protected String fillOutTemplate(StatementBuilder.DmlType dmlType, String template, IDataLoaderContext ctx, String[] data, String[] keys) {
        String[] colNames = null;
        if (data == null) {
            colNames = ctx.getKeyNames();
            data = keys;
        } else {
            colNames = ctx.getColumnNames();
        }
        for (int i = 0; i < data.length; ++i) {
            String col = colNames[i];
            template = this.replace(template, col, this.format(col, data[i]));
        }
        template = template.replace("DMLTYPE", dmlType.name());
        template = template.replace("TIMESTAMP", Long.toString(System.currentTimeMillis()));
        return template;
    }

    protected String format(String col, String data) {
        IFormat formatter;
        if (this.columnNameToDataFormatter != null && (formatter = this.columnNameToDataFormatter.get(col)) != null) {
            try {
                data = formatter.format(data);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        return data;
    }

    protected String replace(String template, String token, String value) {
        if (value == null) {
            value = "";
        }
        if (template != null) {
            template = template.replace("%" + token + "%", value);
        }
        return template;
    }

    public void setColumnNameToDataFormatter(Map<String, IFormat> columnNameToDataFormatter) {
        this.columnNameToDataFormatter = columnNameToDataFormatter;
    }

    public void setProcessDelete(boolean processDeletes) {
        this.processDelete = processDeletes;
    }

    public void setProcessInsert(boolean processInserts) {
        this.processInsert = processInserts;
    }

    public void setProcessUpdate(boolean processUpdates) {
        this.processUpdate = processUpdates;
    }

    public void setHeaderTableTemplate(String headerTableTemplate) {
        this.headerTableTemplate = headerTableTemplate;
    }

    public void setFooterTableTemplate(String footerTableTemplate) {
        this.footerTableTemplate = footerTableTemplate;
    }

    public void setContentTableTemplate(String contentTableTemplate) {
        this.contentTableTemplate = contentTableTemplate;
    }

    public void setDataFilter(IDataLoaderFilter dataFilter) {
        this.dataFilter = dataFilter;
    }

    public static interface IFormat {
        public String format(String var1) throws ParseException;
    }
}

