/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Connection;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.xml.DOMConfigurator;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.StandaloneSymmetricEngine;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.SymmetricWebServer;
import org.jumpmind.symmetric.common.Message;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.db.SqlScript;
import org.jumpmind.symmetric.ddl.Platform;
import org.jumpmind.symmetric.ddl.io.DatabaseIO;
import org.jumpmind.symmetric.ddl.model.Database;
import org.jumpmind.symmetric.profile.IProfile;
import org.jumpmind.symmetric.service.IDataExtractorService;
import org.jumpmind.symmetric.service.IDataLoaderService;
import org.jumpmind.symmetric.service.IDataService;
import org.jumpmind.symmetric.service.IPurgeService;
import org.jumpmind.symmetric.service.IRegistrationService;
import org.jumpmind.symmetric.service.ISecurityService;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.symmetric.transport.IOutgoingTransport;
import org.jumpmind.symmetric.transport.internal.InternalOutgoingTransport;
import org.jumpmind.symmetric.util.AppUtils;
import org.jumpmind.symmetric.util.JarBuilder;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SymmetricLauncher {
    private static final String OPTION_DUMP_BATCH = "dump-batch";
    private static final String OPTION_OPEN_REGISTRATION = "open-registration";
    private static final String OPTION_RELOAD_NODE = "reload-node";
    private static final String OPTION_AUTO_CREATE = "auto-create";
    private static final String OPTION_PORT_SERVER = "port";
    private static final String OPTION_SECURE_PORT_SERVER = "secure-port";
    private static final String OPTION_MAX_IDLE_TIME = "max-idle-time";
    private static final String OPTION_DDL_GEN = "generate-config-ddl";
    private static final String OPTION_TRIGGER_GEN = "generate-triggers";
    private static final String OPTION_TRIGGER_GEN_ALWAYS = "generate-triggers-always";
    private static final String OPTION_PURGE = "purge";
    private static final String OPTION_RUN_DDL_XML = "run-ddl";
    private static final String OPTION_RUN_SQL = "run-sql";
    private static final String OPTION_RUN_PROFILE = "run-profile";
    private static final String OPTION_PROPERTIES_GEN = "generate-default-properties";
    private static final String OPTION_EXPORT_SCHEMA = "export-schema";
    private static final String OPTION_PROPERTIES_FILE = "properties";
    private static final String OPTION_START_SERVER = "server";
    private static final String OPTION_START_CLIENT = "client";
    private static final String OPTION_START_SECURE_SERVER = "secure-server";
    private static final String OPTION_START_MIXED_SERVER = "mixed-server";
    private static final String OPTION_NO_NIO = "no-nio";
    private static final String OPTION_NO_DIRECT_BUFFER = "no-directbuffer";
    private static final String OPTION_LOAD_BATCH = "load-batch";
    private static final String OPTION_SKIP_DB_VALIDATION = "skip-db-validate";
    private static final String OPTION_ENCRYPT_TEXT = "encrypt";
    private static final String OPTION_VERBOSE_CONSOLE = "verbose";
    private static final String OPTION_DEBUG = "debug";
    private static final String OPTION_PROFILE = "profile";
    private static final String OPTION_NOCONSOLE = "noconsole";
    private static final String OPTION_NOLOGFILE = "nologfile";
    private static final String OPTION_CREATE_WAR = "create-war";
    private static final String MESSAGE_BUNDLE = "Launcher.Option.";
    private static final String OPTION_KEYSTORE_PASSWORD = "keystore-password";
    private static final String OPTION_KEYSTORE_TYPE = "keystore-type";
    protected SymmetricWebServer webServer;
    protected Exception exception;
    protected boolean join = true;

    public static void main(String ... args) throws Exception {
        new SymmetricLauncher().execute(args);
    }

    public void execute(String ... args) throws Exception {
        PosixParser parser = new PosixParser();
        Options options = new Options();
        this.buildOptions(options);
        try {
            CommandLine line = parser.parse(options, args);
            this.configureLogging(line);
            if (line.getOptions() != null) {
                for (Option option : line.getOptions()) {
                    LogFactory.getLog(SymmetricLauncher.class).info("Option", new Object[]{option.getLongOpt(), ArrayUtils.toString((Object)option.getValues())});
                }
            }
            if (!this.executeOptions(line)) {
                this.printHelp(options);
            }
        }
        catch (ParseException exp) {
            this.exception = exp;
            System.err.println(exp.getMessage());
            this.printHelp(options);
            System.exit(-1);
        }
        catch (Exception ex) {
            this.exception = ex;
            System.err.println("-----------------------------------------------------------------------------------------------");
            System.err.println(Message.get((String)"ExceptionGeneral"));
            System.err.println("-----------------------------------------------------------------------------------------------");
            ExceptionUtils.printRootCauseStackTrace((Throwable)ex, (PrintStream)System.err);
            System.err.println("-----------------------------------------------------------------------------------------------");
            System.exit(-1);
        }
    }

    private void generateWar(String warFileName, String propertiesFileName) throws Exception {
        File propsFile;
        File workingDirectory = new File("../.war");
        FileUtils.deleteDirectory((File)workingDirectory);
        FileUtils.copyDirectory((File)new File("../web"), (File)workingDirectory);
        FileUtils.copyDirectory((File)new File("../conf"), (File)new File(workingDirectory, "WEB-INF/classes"));
        if (propertiesFileName != null && (propsFile = new File(propertiesFileName)).exists()) {
            FileUtils.copyFile((File)propsFile, (File)new File(workingDirectory, "WEB-INF/classes/symmetric.properties"));
        }
        JarBuilder builder = new JarBuilder(workingDirectory, new File(warFileName), new File[]{workingDirectory});
        builder.build();
        FileUtils.deleteDirectory((File)workingDirectory);
    }

    private boolean isStartApplicationOption(CommandLine line) {
        return line.hasOption(OPTION_START_CLIENT) || line.hasOption(OPTION_START_SERVER) || line.hasOption(OPTION_START_SECURE_SERVER) || line.hasOption(OPTION_START_MIXED_SERVER);
    }

    private File getLog4JFile() throws MalformedURLException {
        URL url = new URL(System.getProperty("log4j.configuration", "file:../conf/log4j-blank.xml"));
        return new File(new File(url.getFile()).getParent(), "log4j.xml");
    }

    private File getLog4JFileDebugEnabled() throws MalformedURLException {
        File original = this.getLog4JFile();
        return new File(original.getParent(), "log4j-debug.xml");
    }

    private void printHelp(Options options) {
        new HelpFormatter().printHelp("sym", options);
    }

    private void testConnection(CommandLine line) throws Exception {
        if (!line.hasOption(OPTION_SKIP_DB_VALIDATION)) {
            ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext(new String[]{"classpath:/symmetric-properties.xml", "classpath:/symmetric-database.xml"});
            BasicDataSource ds = (BasicDataSource)ctx.getBean("dataSource");
            Connection c = ds.getConnection();
            c.close();
            ds.close();
        }
    }

    private void configureLogging(CommandLine line) throws MalformedURLException {
        Layout layout;
        Appender consoleAppender;
        File log4jFile = this.getLog4JFile();
        if (line.hasOption(OPTION_DEBUG)) {
            log4jFile = this.getLog4JFileDebugEnabled();
        }
        if (log4jFile.exists()) {
            DOMConfigurator.configure((String)log4jFile.getAbsolutePath());
        }
        if (line.hasOption(OPTION_VERBOSE_CONSOLE) && (consoleAppender = Logger.getRootLogger().getAppender("CONSOLE")) != null && (layout = consoleAppender.getLayout()) instanceof PatternLayout) {
            ((PatternLayout)layout).setConversionPattern("%d %-5p [%c{2}] [%t] %m%n");
        }
        if (line.hasOption(OPTION_NOCONSOLE)) {
            Logger.getRootLogger().removeAppender("CONSOLE");
        }
        if (line.hasOption(OPTION_NOLOGFILE)) {
            Logger.getRootLogger().removeAppender("ROLLING");
        } else {
            Appender appender = Logger.getRootLogger().getAppender("ROLLING");
            if (appender instanceof FileAppender) {
                FileAppender fileAppender = (FileAppender)appender;
                if (line.hasOption(OPTION_PROPERTIES_FILE) && this.isStartApplicationOption(line)) {
                    File file = new File(line.getOptionValue(OPTION_PROPERTIES_FILE));
                    String name = file.getName();
                    int index = name.lastIndexOf(".");
                    if (index > 0) {
                        name = name.substring(0, index);
                    }
                    fileAppender.setFile(fileAppender.getFile().replace("symmetric.log", name + ".log"));
                    fileAppender.activateOptions();
                }
                System.out.println(Message.get((String)"LauncherLogLocation", (Object[])new Object[]{fileAppender.getFile()}));
            }
        }
    }

    protected void addPropertiesOption(Options options) {
        this.addOption(options, "p", OPTION_PROPERTIES_FILE, true);
    }

    protected void buildOptions(Options options) {
        this.addOption(options, "S", OPTION_START_SERVER, false);
        this.addOption(options, "C", OPTION_START_CLIENT, false);
        this.addOption(options, "T", OPTION_START_SECURE_SERVER, false);
        this.addOption(options, "U", OPTION_START_MIXED_SERVER, false);
        this.addOption(options, "P", OPTION_PORT_SERVER, true);
        this.addOption(options, "Q", OPTION_SECURE_PORT_SERVER, true);
        this.addOption(options, "I", OPTION_MAX_IDLE_TIME, true);
        this.addOption(options, "nnio", OPTION_NO_NIO, false);
        this.addOption(options, "ndb", OPTION_NO_DIRECT_BUFFER, false);
        this.addOption(options, "c", OPTION_DDL_GEN, true);
        this.addPropertiesOption(options);
        this.addOption(options, "X", OPTION_PURGE, false);
        this.addOption(options, "g", OPTION_PROPERTIES_GEN, true);
        this.addOption(options, "r", OPTION_RUN_DDL_XML, true);
        this.addOption(options, "s", OPTION_RUN_SQL, true);
        this.addOption(options, OPTION_PROFILE, OPTION_RUN_PROFILE, true);
        this.addOption(options, "a", OPTION_AUTO_CREATE, false);
        this.addOption(options, "R", OPTION_OPEN_REGISTRATION, true);
        this.addOption(options, "l", OPTION_RELOAD_NODE, true);
        this.addOption(options, "d", OPTION_DUMP_BATCH, true);
        this.addOption(options, "b", OPTION_LOAD_BATCH, true);
        this.addOption(options, "t", OPTION_TRIGGER_GEN, true);
        this.addOption(options, "o", OPTION_TRIGGER_GEN_ALWAYS, false);
        this.addOption(options, "e", OPTION_ENCRYPT_TEXT, true);
        this.addOption(options, "v", OPTION_VERBOSE_CONSOLE, false);
        this.addOption(options, OPTION_DEBUG, OPTION_DEBUG, false);
        this.addOption(options, OPTION_NOCONSOLE, OPTION_NOCONSOLE, false);
        this.addOption(options, OPTION_NOLOGFILE, OPTION_NOLOGFILE, false);
        this.addOption(options, "w", OPTION_CREATE_WAR, true);
        this.addOption(options, "x", OPTION_EXPORT_SCHEMA, true);
        this.addOption(options, "y", OPTION_ENCRYPT_TEXT, true);
        this.addOption(options, "ksp", OPTION_KEYSTORE_PASSWORD, true);
        this.addOption(options, "kst", OPTION_KEYSTORE_TYPE, true);
    }

    protected boolean executeOptions(CommandLine line) throws Exception {
        int port = Integer.parseInt(SymmetricWebServer.DEFAULT_HTTP_PORT);
        int securePort = Integer.parseInt(SymmetricWebServer.DEFAULT_HTTPS_PORT);
        String webDir = SymmetricWebServer.DEFAULT_WEBAPP_DIR;
        int maxIdleTime = 900000;
        String propertiesFile = null;
        boolean noNio = false;
        boolean noDirectBuffer = false;
        if (line.hasOption(OPTION_PORT_SERVER)) {
            port = new Integer(line.getOptionValue(OPTION_PORT_SERVER));
        }
        if (line.hasOption(OPTION_SECURE_PORT_SERVER)) {
            securePort = new Integer(line.getOptionValue(OPTION_SECURE_PORT_SERVER));
        }
        if (line.hasOption(OPTION_KEYSTORE_PASSWORD)) {
            System.setProperty("javax.net.ssl.keyStorePassword", line.getOptionValue(OPTION_KEYSTORE_PASSWORD));
        }
        if (line.hasOption(OPTION_KEYSTORE_TYPE)) {
            System.setProperty("sym.keystore.type", line.getOptionValue(OPTION_KEYSTORE_TYPE));
        }
        if (line.hasOption(OPTION_MAX_IDLE_TIME)) {
            maxIdleTime = new Integer(line.getOptionValue(OPTION_MAX_IDLE_TIME));
        }
        if (line.hasOption(OPTION_NO_NIO)) {
            noNio = true;
        }
        if (line.hasOption(OPTION_NO_DIRECT_BUFFER)) {
            noDirectBuffer = true;
        }
        if (line.hasOption(OPTION_PROPERTIES_GEN)) {
            this.generateDefaultProperties(line.getOptionValue(OPTION_PROPERTIES_GEN));
            System.exit(0);
            return true;
        }
        if (line.hasOption(OPTION_PROPERTIES_FILE)) {
            propertiesFile = "file:" + line.getOptionValue(OPTION_PROPERTIES_FILE);
            System.setProperty("symmetric.override.properties.file.1", propertiesFile);
            if (!new File(line.getOptionValue(OPTION_PROPERTIES_FILE)).exists()) {
                throw new SymmetricException("FilePropertiesNotFound", new Object[]{line.getOptionValue(OPTION_PROPERTIES_FILE)});
            }
        } else {
            propertiesFile = this.choosePropertiesFile(line, propertiesFile);
        }
        if (line.hasOption(OPTION_CREATE_WAR)) {
            this.generateWar(line.getOptionValue(OPTION_CREATE_WAR), propertiesFile);
            System.exit(0);
            return true;
        }
        if (line.hasOption(OPTION_DDL_GEN)) {
            this.testConnection(line);
            this.generateDDL(this.createEngine(propertiesFile), line.getOptionValue(OPTION_DDL_GEN));
            System.exit(0);
            return true;
        }
        if (line.hasOption(OPTION_PURGE)) {
            this.testConnection(line);
            ((IPurgeService)this.createEngine(propertiesFile).getApplicationContext().getBean("purgeService")).purgeOutgoing();
            System.exit(0);
            return true;
        }
        if (line.hasOption(OPTION_OPEN_REGISTRATION)) {
            this.testConnection(line);
            String arg = line.getOptionValue(OPTION_OPEN_REGISTRATION);
            this.openRegistration(this.createEngine(propertiesFile), arg);
            System.out.println(Message.get((String)"RegistrationOpened", (Object[])new Object[]{arg}));
            System.exit(0);
            return true;
        }
        if (line.hasOption(OPTION_RELOAD_NODE)) {
            this.testConnection(line);
            String arg = line.getOptionValue(OPTION_RELOAD_NODE);
            String message = this.reloadNode(this.createEngine(propertiesFile), arg);
            System.out.println(message);
            System.exit(0);
            return true;
        }
        if (line.hasOption(OPTION_DUMP_BATCH)) {
            this.testConnection(line);
            String arg = line.getOptionValue(OPTION_DUMP_BATCH);
            this.dumpBatch(this.createEngine(propertiesFile), arg);
            System.exit(0);
            return true;
        }
        if (line.hasOption(OPTION_TRIGGER_GEN)) {
            this.testConnection(line);
            String arg = line.getOptionValue(OPTION_TRIGGER_GEN);
            boolean gen_always = line.hasOption(OPTION_TRIGGER_GEN_ALWAYS);
            this.syncTrigger(this.createEngine(propertiesFile), arg, gen_always);
            System.exit(0);
            return true;
        }
        if (line.hasOption(OPTION_AUTO_CREATE)) {
            this.testConnection(line);
            this.autoCreateDatabase(this.createEngine(propertiesFile));
            System.exit(0);
            return true;
        }
        if (line.hasOption(OPTION_EXPORT_SCHEMA)) {
            this.testConnection(line);
            this.exportSchema(this.createEngine(propertiesFile), line.getOptionValue(OPTION_EXPORT_SCHEMA));
            System.exit(0);
            return true;
        }
        if (line.hasOption(OPTION_RUN_DDL_XML)) {
            this.testConnection(line);
            this.runDdlXml(this.createEngine(propertiesFile), line.getOptionValue(OPTION_RUN_DDL_XML));
            System.exit(0);
            return true;
        }
        if (line.hasOption(OPTION_RUN_SQL)) {
            this.testConnection(line);
            this.runSql(this.createEngine(propertiesFile), line.getOptionValue(OPTION_RUN_SQL));
            System.exit(0);
            return true;
        }
        if (line.hasOption(OPTION_RUN_PROFILE)) {
            this.testConnection(line);
            SymmetricLauncher.runProfile(this.createEngine(propertiesFile), line.getOptionValue(OPTION_RUN_PROFILE));
            System.exit(0);
            return true;
        }
        if (line.hasOption(OPTION_LOAD_BATCH)) {
            this.testConnection(line);
            this.loadBatch(this.createEngine(propertiesFile), line.getOptionValue(OPTION_LOAD_BATCH));
            System.exit(0);
            return true;
        }
        if (line.hasOption(OPTION_ENCRYPT_TEXT)) {
            this.testConnection(line);
            this.encryptText(this.createEngine(propertiesFile), line.getOptionValue(OPTION_ENCRYPT_TEXT));
            return true;
        }
        if (line.hasOption(OPTION_START_CLIENT)) {
            this.createEngine(propertiesFile).start();
            return true;
        }
        if (line.hasOption(OPTION_START_SERVER) || line.hasOption(OPTION_START_SECURE_SERVER) || line.hasOption(OPTION_START_MIXED_SERVER)) {
            this.webServer = new SymmetricWebServer(this.chooseWebDir(line, webDir), maxIdleTime, propertiesFile, this.join, noNio, noDirectBuffer);
            if (line.hasOption(OPTION_START_SERVER)) {
                this.webServer.start(port);
            } else if (line.hasOption(OPTION_START_SECURE_SERVER)) {
                this.webServer.startSecure(securePort);
            } else {
                this.webServer.startMixed(port, securePort);
            }
            return true;
        }
        return false;
    }

    protected String choosePropertiesFile(CommandLine line, String propertiesFile) {
        return propertiesFile;
    }

    protected String chooseWebDir(CommandLine line, String webDir) {
        return webDir;
    }

    protected ISymmetricEngine createEngine(String propertiesFile) {
        return new StandaloneSymmetricEngine(propertiesFile);
    }

    protected void addOption(Options options, String opt, String longOpt, boolean hasArg) {
        options.addOption(opt, longOpt, hasArg, Message.get((String)(MESSAGE_BUNDLE + longOpt)));
    }

    private void dumpBatch(ISymmetricEngine engine, String batchId) throws Exception {
        IDataExtractorService dataExtractorService = (IDataExtractorService)engine.getApplicationContext().getBean("dataExtractorService");
        InternalOutgoingTransport transport = new InternalOutgoingTransport((OutputStream)System.out);
        dataExtractorService.extractBatchRange((IOutgoingTransport)transport, batchId, batchId);
        transport.close();
    }

    private void loadBatch(ISymmetricEngine engine, String fileName) throws Exception {
        IDataLoaderService service = (IDataLoaderService)engine.getApplicationContext().getBean("dataLoaderService");
        File file = new File(fileName);
        if (!file.exists() || !file.isFile()) {
            throw new SymmetricException("Launcher.Exception.FileNotFound", new Object[]{fileName});
        }
        FileInputStream in = new FileInputStream(file);
        service.loadData((InputStream)in, (OutputStream)System.out);
        System.out.flush();
        in.close();
    }

    private void encryptText(ISymmetricEngine engine, String plainText) {
        ISecurityService service = (ISecurityService)engine.getApplicationContext().getBean("securityService");
        System.out.println("enc:" + service.encrypt(plainText));
    }

    private void exportSchema(ISymmetricEngine engine, String fileName) {
        Platform platform = engine.getDbDialect().getPlatform();
        Database db = platform.readModelFromDatabase("model");
        new DatabaseIO().write(db, fileName);
    }

    private void openRegistration(ISymmetricEngine engine, String argument) {
        int index = (argument = argument.replace('\"', ' ')).trim().indexOf(",");
        if (index < 0) {
            throw new SymmetricException("LauncherMissingFilenameTriggerSQL", new Object[]{OPTION_OPEN_REGISTRATION});
        }
        String nodeGroupId = argument.substring(0, index).trim();
        String externalId = argument.substring(index + 1).trim();
        IRegistrationService registrationService = (IRegistrationService)engine.getApplicationContext().getBean("registrationService");
        registrationService.openRegistration(nodeGroupId, externalId);
    }

    private String reloadNode(ISymmetricEngine engine, String argument) {
        IDataService dataService = (IDataService)engine.getApplicationContext().getBean("dataService");
        return dataService.reloadNode(argument);
    }

    private void syncTrigger(ISymmetricEngine engine, String fileName, boolean gen_always) throws IOException {
        File file;
        if (fileName != null) {
            file = new File(fileName);
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
        } else {
            throw new SymmetricException("MissingFilenameTriggerSQL");
        }
        ITriggerRouterService triggerService = (ITriggerRouterService)AppUtils.find((String)"triggerRouterService", (ISymmetricEngine)engine);
        StringBuilder sqlBuffer = new StringBuilder();
        triggerService.syncTriggers(sqlBuffer, gen_always);
        FileUtils.writeStringToFile((File)file, (String)sqlBuffer.toString(), null);
    }

    private void generateDDL(ISymmetricEngine engine, String fileName) throws IOException {
        File file = new File(fileName);
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        FileWriter os = new FileWriter(file, false);
        os.write(((IDbDialect)engine.getApplicationContext().getBean("dbDialect")).getCreateSymmetricDDL());
        os.close();
    }

    private void generateDefaultProperties(String fileName) throws IOException {
        File file = new File(fileName);
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        BufferedReader is = new BufferedReader(new InputStreamReader(SymmetricLauncher.class.getResourceAsStream("/symmetric-default.properties"), Charset.defaultCharset()));
        FileWriter os = new FileWriter(file, false);
        String line = is.readLine();
        while (line != null) {
            os.write(line);
            os.write(System.getProperty("line.separator"));
            line = is.readLine();
        }
        is.close();
        os.close();
    }

    private void autoCreateDatabase(ISymmetricEngine engine) {
        engine.setupDatabase(true);
    }

    private void runDdlXml(ISymmetricEngine engine, String fileName) throws FileNotFoundException {
        IDbDialect dialect = (IDbDialect)engine.getApplicationContext().getBean("dbDialect");
        File file = new File(fileName);
        if (!file.exists() || !file.isFile()) {
            throw new SymmetricException("FileNotFound", new Object[]{fileName});
        }
        Platform pf = dialect.getPlatform();
        Database db = new DatabaseIO().read(new File(fileName));
        pf.createTables(db, false, true);
    }

    private void runSql(ISymmetricEngine engine, String fileName) throws FileNotFoundException, MalformedURLException {
        IDbDialect dialect = (IDbDialect)engine.getApplicationContext().getBean("dbDialect");
        File file = new File(fileName);
        if (!file.exists() || !file.isFile()) {
            throw new SymmetricException("FileNotFound", new Object[]{fileName});
        }
        SqlScript script = new SqlScript(file.toURI().toURL(), dialect.getPlatform().getDataSource(), true, ";", dialect.getSqlScriptReplacementTokens());
        script.execute();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void runProfile(ISymmetricEngine engine, String profileName) throws FileNotFoundException, MalformedURLException {
        IProfile profile = (IProfile)engine.getApplicationContext().getBean(profileName);
        if (profile == null) throw new SymmetricException("ProfileNotFound", new Object[]{profileName});
        if (!profile.isCompatible(engine)) throw new SymmetricException("ProfileNotCompatible", new Object[]{profileName});
        try {
            profile.configure(engine);
            return;
        }
        catch (Exception ex) {
            throw new SymmetricException("ProfileError", (Throwable)ex, new Object[]{profileName});
        }
    }
}

