/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.xcelerate.app.util;

import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.TextArea;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.robot.Robot;

public class ControlUtil {
    private static Robot eventRobot;

    public static void transferFocusOnEnter(Control control) {
        control.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent KV) {
                if (KV.getCode() == KeyCode.ENTER && !(KV.getTarget() instanceof TextArea)) {
                    eventRobot.keyPress(KeyCode.TAB);
                    eventRobot.keyRelease(KeyCode.TAB);
                    KV.consume();
                }
            }
        });
    }

    public static void transferFocusOnEnter(Control ... controls) {
        for (int i = 0; i < controls.length; ++i) {
            ControlUtil.transferFocusOnEnter(controls[i]);
        }
    }

    public static void transferFocusOnArrowKeys(Control control) {
        control.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent KV) {
                if (KV.getTarget() instanceof TextArea) {
                    return;
                }
                if (KV.getCode() == KeyCode.UP) {
                    eventRobot.keyPress(KeyCode.SHIFT);
                    eventRobot.keyPress(KeyCode.TAB);
                    eventRobot.keyRelease(KeyCode.TAB);
                    eventRobot.keyRelease(KeyCode.SHIFT);
                    KV.consume();
                } else if (KV.getCode() == KeyCode.DOWN) {
                    eventRobot.keyPress(KeyCode.TAB);
                    eventRobot.keyRelease(KeyCode.TAB);
                    KV.consume();
                }
            }
        });
    }

    public static void transferFocusOnArrowKeys(Control ... controls) {
        for (int i = 0; i < controls.length; ++i) {
            ControlUtil.transferFocusOnArrowKeys(controls[i]);
        }
    }

    public static void transferFocusOnUpArrow(Control control) {
        control.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){
            Robot eventRobot = new Robot();

            public void handle(KeyEvent KV) {
                if (KV.getTarget() instanceof TextArea) {
                    return;
                }
                if (KV.getCode() == KeyCode.UP) {
                    this.eventRobot.keyPress(KeyCode.SHIFT);
                    this.eventRobot.keyPress(KeyCode.TAB);
                    this.eventRobot.keyRelease(KeyCode.TAB);
                    this.eventRobot.keyRelease(KeyCode.SHIFT);
                    KV.consume();
                }
            }
        });
    }

    public static void transferFocusOnDownArrow(Control control) {
        control.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){
            Robot eventRobot = new Robot();

            public void handle(KeyEvent KV) {
                if (KV.getTarget() instanceof TextArea) {
                    return;
                }
                if (KV.getCode() == KeyCode.DOWN) {
                    this.eventRobot.keyPress(KeyCode.TAB);
                    this.eventRobot.keyRelease(KeyCode.TAB);
                    KV.consume();
                }
            }
        });
    }

    public static void fireButtonOnEnter(Control control, final Button button) {
        control.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent KV) {
                if (KV.getCode() == KeyCode.ENTER && !(KV.getTarget() instanceof TextArea)) {
                    button.fire();
                    KV.consume();
                }
            }
        });
    }

    public static void executeOnEnter(Control control, final Runnable runnable) {
        control.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent KV) {
                if (KV.getCode() == KeyCode.ENTER && !(KV.getTarget() instanceof TextArea)) {
                    runnable.run();
                    KV.consume();
                }
            }
        });
    }

    static {
        Platform.runLater(() -> {
            try {
                eventRobot = new Robot();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        });
    }
}

