/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.xcelerate.app.factory.builder;

import javafx.scene.Node;
import javafx.util.Builder;
import rs.tetrabyte.xcelerate.app.control.XMenuItem;
import rs.tetrabyte.xcelerate.app.factory.GlyphFactory;
import rs.tetrabyte.xcelerate.app.util.AcceleratedLabel;
import rs.tetrabyte.xcelerate.app.util.StringUtils;

public class MenuItemBuilder
extends XMenuItem
implements Builder<XMenuItem> {
    private String label;
    private String accelerator;
    private String glyph;

    public XMenuItem build() {
        this.parseText(this.getText());
        this.setButtonText(this.label);
        if (!StringUtils.isEmpty(this.accelerator)) {
            this.setAcceleratorString(this.accelerator);
        }
        if (!StringUtils.isEmpty(this.glyph)) {
            this.setGlyph(this.glyph);
        } else {
            this.setGlyph((Node)GlyphFactory.createGlyph());
        }
        this.setText(null);
        return this;
    }

    private void parseText(String text) {
        if (!StringUtils.isEmpty(text)) {
            AcceleratedLabel acc = AcceleratedLabel.parse(text);
            this.label = acc.getText();
            if (acc.getAccelerator() != null) {
                this.accelerator = acc.getAccelerator();
            }
            if (acc.getGlyphCode() != null) {
                this.glyph = acc.getGlyphCode();
            }
        }
    }
}

