/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.xcelerate.app.factory;

import java.util.Optional;

public enum XButtonType {
    New("new"),
    Edit("edit"),
    Delete("delete"),
    Ok("ok"),
    Cancel("cancel"),
    PreviousPage("previous-page"),
    NextPage("next-page"),
    Save("save"),
    Back("back"),
    Refresh("refresh"),
    Search("search"),
    SearchAdvanced("search-advanced"),
    Sort("sort"),
    Order("order"),
    Ascending("asc"),
    Descending("desc"),
    Table("table"),
    Grid("grid"),
    User("user"),
    Menu("menu"),
    Login("login"),
    Logout("logout");

    private String id;
    private String textKey;

    private XButtonType(String id, String textKey) {
        this.id = id;
        this.textKey = textKey;
    }

    private XButtonType(String name) {
        this("xbtn-" + name, "xbtn." + name);
    }

    public String getId() {
        return this.id;
    }

    public String getTextKey() {
        return this.textKey;
    }

    public static Optional<XButtonType> getButtonType(String id) {
        if (id == null || "".equals(id)) {
            return Optional.empty();
        }
        XButtonType type = null;
        for (int i = 0; i < XButtonType.values().length && type == null; ++i) {
            if (!XButtonType.values()[i].id.equals(id)) continue;
            type = XButtonType.values()[i];
        }
        return Optional.ofNullable(type);
    }
}

