/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.xcelerate.app.control;

import java.util.List;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.BorderPane;
import rs.tetrabyte.xcelerate.app.action.ActionBuilder;
import rs.tetrabyte.xcelerate.app.context.UiSettingService;
import rs.tetrabyte.xcelerate.app.factory.XButtonFactory;
import rs.tetrabyte.xcelerate.app.factory.XButtonType;

public class SubScreen
extends BorderPane {
    private ToolBar toolbar;
    private Button closeButton;
    private EventHandler<Event> onDeactivate;
    private UiSettingService uiSettingService;

    public SubScreen(Node content, boolean singleton, boolean closable, List<ActionBuilder> actions, XButtonFactory buttonFactory, UiSettingService uiSettingService) {
        this.uiSettingService = uiSettingService;
        if (closable) {
            this.closeButton = buttonFactory.createButton(XButtonType.Back);
            this.closeButton.setOnAction(e -> {
                if (this.onDeactivate != null) {
                    this.onDeactivate.handle(null);
                }
                uiSettingService.save(content);
                this.closeButton.setOnAction(null);
            });
            this.addToolbarItem((Node)this.closeButton);
        }
        if (actions != null) {
            actions.forEach(action -> this.addToolbarItem((Node)action.build()));
        }
        if (closable) {
            this.getStyleClass().add((Object)"sub-screen");
        }
        this.setCenter(content);
        this.uiSettingService.restore(content);
    }

    private void addToolbarItem(Node node) {
        if (node == null) {
            return;
        }
        node.setFocusTraversable(false);
        if (this.toolbar == null) {
            this.toolbar = new ToolBar();
            this.setTop((Node)this.toolbar);
        }
        this.toolbar.getItems().add((Object)node);
    }

    public void setOnDeactivate(EventHandler<Event> onDeactivate) {
        this.onDeactivate = onDeactivate;
    }

    public EventHandler<Event> getOnDeactivate() {
        return this.onDeactivate;
    }

    public String toString() {
        return this.getCenter().getId();
    }
}

