/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.xcelerate.app.control;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.DialogPane;
import javafx.scene.layout.BorderPane;
import rs.tetrabyte.xcelerate.app.commands.RemoveView;
import rs.tetrabyte.xcelerate.app.commands.ShowDialog;

public class PFXDialog<T> {
    private DialogPane dialogPane;
    private ObjectProperty<T> value = new SimpleObjectProperty();
    private RemoveView removeViewCommand;
    private ButtonBar buttonBar;

    public PFXDialog(ShowDialog<T> showDialog, RemoveView removeView) {
        this.removeViewCommand = removeView;
        Alert a = new Alert(Alert.AlertType.NONE);
        this.dialogPane = a.getDialogPane();
        this.dialogPane.setHeaderText(showDialog.getTitle());
        this.dialogPane.setGraphic(showDialog.getGraphic());
        if (showDialog.getHeight() != 0) {
            this.dialogPane.setPrefHeight((double)showDialog.getHeight());
        }
        if (showDialog.getWidth() != 0) {
            this.dialogPane.setPrefWidth((double)showDialog.getWidth());
            this.dialogPane.setMaxWidth((double)showDialog.getWidth());
        }
        this.buttonBar = new ButtonBar();
        this.buttonBar.getButtons().addAll(showDialog.getButtons());
        BorderPane bp = new BorderPane(showDialog.getContent(), null, null, (Node)this.buttonBar, null);
        this.dialogPane.setContent((Node)bp);
        if (showDialog.getOnValueSet() != null) {
            this.value.addListener((o, ov, nv) -> showDialog.getOnValueSet().accept(this));
        }
    }

    public final ObjectProperty<T> valueProperty() {
        return this.value;
    }

    public final T getValue() {
        return (T)this.valueProperty().get();
    }

    public final void setValue(T value) {
        this.valueProperty().set(value);
    }

    public DialogPane getDialogPane() {
        return this.dialogPane;
    }

    public ObservableList<Node> getButtons() {
        return this.buttonBar.getButtons();
    }

    public void close() {
        this.removeViewCommand.withView((Node)this.dialogPane).execute();
    }
}

