/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.xcelerate.app.control;

import rs.tetrabyte.xcelerate.app.jiconfont.DefaultIconCode;
import rs.tetrabyte.xcelerate.app.jiconfont.IconNode;

public class Glyph
extends IconNode {
    public Glyph() {
        this.getStyleClass().add((Object)"glyph");
    }

    public void setGlyphCode(Code code) {
        this.setIconCode(new DefaultIconCode(code.getFontFamily(), code.getUnicode()));
    }

    public static class Code {
        private String fontFamily;
        private char unicode;

        public Code(String fontFamily, char chr) {
            this.fontFamily = fontFamily;
            this.unicode = chr;
        }

        public String getFontFamily() {
            return this.fontFamily;
        }

        public void setFontFamily(String fontFamily) {
            this.fontFamily = fontFamily;
        }

        public char getUnicode() {
            return this.unicode;
        }

        public void setChr(char chr) {
            this.unicode = chr;
        }

        public static Code parseGlyphCode(String string) {
            String code;
            if (string == null || string.isEmpty()) {
                throw new IllegalArgumentException("Couldn't create glyph with null or empty code");
            }
            String[] split = string.split(":");
            if (split.length == 0) {
                throw new IllegalArgumentException("Couldn't create glyph. Bad code.");
            }
            String fontFamily = "default";
            if (split.length == 1) {
                code = split[0];
            } else {
                fontFamily = split[0];
                code = split[1];
            }
            try {
                int hexVal = Integer.parseInt(code, 16);
                return new Code(fontFamily, (char)hexVal);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Couldn't parse glyph code: " + code, e);
            }
        }
    }
}

