/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.xcelerate.app.control;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.css.CssMetaData;
import javafx.css.FontCssMetaData;
import javafx.css.StyleConverter;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.EnumConverter;
import javafx.css.converter.PaintConverter;
import javafx.scene.Node;
import javafx.scene.control.Labeled;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;

public class Accelerated
extends Labeled {
    private StringProperty acceleratorString;
    private ObjectProperty<Paint> acceleratorFill;
    private ObjectProperty<Font> acceleratorFont;
    private ObjectProperty<TextAlignment> acceleratorAlignment;

    public Accelerated() {
    }

    public Accelerated(String text) {
        super(text);
    }

    public Accelerated(String text, Node graphic) {
        super(text, graphic);
    }

    public Accelerated(String text, Node graphic, String accelerator) {
        super(text, graphic);
        this.setAcceleratorString(accelerator);
    }

    public final StringProperty acceleratorStringProperty() {
        if (this.acceleratorString == null) {
            this.acceleratorString = new SimpleStringProperty((Object)this, "accelerator", null);
        }
        return this.acceleratorString;
    }

    public final String getAcceleratorString() {
        return (String)this.acceleratorStringProperty().get();
    }

    public final void setAcceleratorString(String accelerator) {
        this.acceleratorStringProperty().set((Object)accelerator);
    }

    public final void setAcceleratorFill(Paint value) {
        this.acceleratorFillProperty().set((Object)value);
    }

    public final Paint getAcceleratorFill() {
        return this.acceleratorFill == null ? Color.BLACK : (Paint)this.acceleratorFill.get();
    }

    public final ObjectProperty<Paint> acceleratorFillProperty() {
        if (this.acceleratorFill == null) {
            this.acceleratorFill = new StyleableObjectProperty<Paint>((Paint)Color.BLACK){

                public CssMetaData<Accelerated, Paint> getCssMetaData() {
                    return StyleableProperties.ACCELERATOR_FILL;
                }

                public Object getBean() {
                    return Accelerated.this;
                }

                public String getName() {
                    return "acceleratorFill";
                }
            };
        }
        return this.acceleratorFill;
    }

    public final ObjectProperty<Font> acceleratorFontProperty() {
        if (this.acceleratorFont == null) {
            this.acceleratorFont = new StyleableObjectProperty<Font>(Font.getDefault()){
                private boolean fontSetByCss;
                {
                    this.fontSetByCss = false;
                }

                public void applyStyle(StyleOrigin newOrigin, Font value) {
                    try {
                        this.fontSetByCss = true;
                        super.applyStyle(newOrigin, (Object)value);
                    }
                    catch (Exception e) {
                        throw e;
                    }
                    finally {
                        this.fontSetByCss = false;
                    }
                }

                public void set(Font value) {
                    Font oldValue = (Font)this.get();
                    if (value != null ? !value.equals((Object)oldValue) : oldValue != null) {
                        super.set((Object)value);
                    }
                }

                protected void invalidated() {
                    if (!this.fontSetByCss) {
                        // empty if block
                    }
                }

                public CssMetaData<Accelerated, Font> getCssMetaData() {
                    return StyleableProperties.ACCELERATOR_FONT;
                }

                public Object getBean() {
                    return Accelerated.this;
                }

                public String getName() {
                    return "acceleratorFont";
                }
            };
        }
        return this.acceleratorFont;
    }

    public final void setAcceleratorFont(Font value) {
        this.acceleratorFontProperty().setValue((Object)value);
    }

    public final Font getAcceleratorFont() {
        return this.acceleratorFont == null ? Font.getDefault() : (Font)this.acceleratorFont.getValue();
    }

    public final ObjectProperty<TextAlignment> acceleratorAlignmentProperty() {
        if (this.acceleratorAlignment == null) {
            this.acceleratorAlignment = new StyleableObjectProperty<TextAlignment>(TextAlignment.LEFT){

                public CssMetaData<Accelerated, TextAlignment> getCssMetaData() {
                    return StyleableProperties.ACCELERATOR_ALIGNMENT;
                }

                public Object getBean() {
                    return Accelerated.this;
                }

                public String getName() {
                    return "acceleratorAlignment";
                }
            };
        }
        return this.acceleratorAlignment;
    }

    public final void setAcceleratorAlignment(TextAlignment value) {
        this.acceleratorAlignmentProperty().setValue((Object)value);
    }

    public final TextAlignment getAcceleratorAlignment() {
        return this.acceleratorAlignment == null ? TextAlignment.LEFT : (TextAlignment)this.acceleratorAlignment.getValue();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return Accelerated.getClassCssMetaData();
    }

    private static class StyleableProperties {
        private static final FontCssMetaData<Accelerated> ACCELERATOR_FONT = new FontCssMetaData<Accelerated>("-fx-accelerator-font", Font.getDefault()){

            public boolean isSettable(Accelerated n) {
                return n.acceleratorFont == null || !n.acceleratorFont.isBound();
            }

            public StyleableProperty<Font> getStyleableProperty(Accelerated n) {
                return (StyleableProperty)n.acceleratorFontProperty();
            }
        };
        private static final CssMetaData<Accelerated, TextAlignment> ACCELERATOR_ALIGNMENT = new CssMetaData<Accelerated, TextAlignment>("-fx-accelerator-alignment", (StyleConverter)new EnumConverter(TextAlignment.class), TextAlignment.LEFT){

            public boolean isSettable(Accelerated n) {
                return n.acceleratorAlignment == null || !n.acceleratorAlignment.isBound();
            }

            public StyleableProperty<TextAlignment> getStyleableProperty(Accelerated n) {
                return (StyleableProperty)n.acceleratorAlignmentProperty();
            }
        };
        private static final CssMetaData<Accelerated, Paint> ACCELERATOR_FILL = new CssMetaData<Accelerated, Paint>("-fx-accelerator-fill", PaintConverter.getInstance(), (Paint)Color.BLACK){

            public boolean isSettable(Accelerated n) {
                return n.acceleratorFill == null || !n.acceleratorFill.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(Accelerated n) {
                return (StyleableProperty)n.acceleratorFillProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Labeled.getClassCssMetaData());
            Collections.addAll(styleables, ACCELERATOR_FONT, ACCELERATOR_ALIGNMENT, ACCELERATOR_FILL);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

