/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.xcelerate.app.context.impl;

import java.util.Optional;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs.tetrabyte.xcelerate.app.context.FocusService;

public class FocusServiceImpl
implements FocusService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FocusServiceImpl.class);
    private Scene scene;

    public void setScene(Scene scene) {
        this.scene = scene;
        this.scene.focusOwnerProperty().addListener((o, ov, nv) -> LOGGER.trace("Focus: " + nv));
    }

    @Override
    public Node getFocusedNode() {
        return this.scene.getFocusOwner();
    }

    private void setFocus(final Node node, final long delay) {
        if (node == null) {
            return;
        }
        Task<Optional<Node>> task = new Task<Optional<Node>>(){

            protected Optional<Node> call() throws Exception {
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (node instanceof Parent) {
                    return FocusServiceImpl.this.findFirstControl((Parent)node);
                }
                return Optional.of(node);
            }
        };
        task.setOnSucceeded(arg_0 -> FocusServiceImpl.lambda$setFocus$3((Task)task, arg_0));
        new Thread((Runnable)task).start();
    }

    @Override
    public void setFocus(Node node) {
        this.setFocus(node, 100L);
    }

    private Optional<Node> findFirstControl(Parent parent) {
        if (parent == null) {
            return Optional.empty();
        }
        for (Node node : parent.getChildrenUnmodifiable()) {
            Optional<Node> c;
            if (node.isFocusTraversable() && !node.isDisabled()) {
                return Optional.of(node);
            }
            if (!(node instanceof Parent) || !(c = this.findFirstControl((Parent)node)).isPresent()) continue;
            return c;
        }
        return Optional.empty();
    }

    private static /* synthetic */ void lambda$setFocus$3(Task task, WorkerStateEvent e) {
        try {
            ((Optional)task.get()).ifPresent(c -> {
                LOGGER.trace("Setting focus on: " + c);
                Platform.runLater(() -> c.requestFocus());
            });
        }
        catch (Exception e1) {
            LOGGER.error("Focus service error", (Object)e);
        }
    }
}

