/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.xcelerate.app.commands;

import javafx.scene.Node;
import rs.tetrabyte.xcelerate.app.commands.ClearScreen;
import rs.tetrabyte.xcelerate.app.commands.DisplayContent;
import rs.tetrabyte.xcelerate.app.commands.LockUI;
import rs.tetrabyte.xcelerate.app.commands.PopContent;
import rs.tetrabyte.xcelerate.app.commands.RemoveView;
import rs.tetrabyte.xcelerate.app.commands.ShowAlert;
import rs.tetrabyte.xcelerate.app.commands.ShowDialog;
import rs.tetrabyte.xcelerate.app.commands.ShowNotification;
import rs.tetrabyte.xcelerate.app.commands.UICommandFactory;
import rs.tetrabyte.xcelerate.app.commands.UnlockUI;
import rs.tetrabyte.xcelerate.core.fxml.FXMLValuePair;

public class UICommands {
    private UICommandFactory factory;

    public UICommands(UICommandFactory factory) {
        this.factory = factory;
    }

    public DisplayContent displayContent(Node content) {
        return this.factory.createCommand(DisplayContent.class).content(content);
    }

    public <C> DisplayContent displayContent(FXMLValuePair<Node, C> fxml) {
        return this.factory.createCommand(DisplayContent.class).fxml(fxml);
    }

    public PopContent popContent() {
        return this.factory.createCommand(PopContent.class);
    }

    public LockUI lockUI() {
        return this.factory.createCommand(LockUI.class);
    }

    public UnlockUI unLockUI() {
        return this.factory.createCommand(UnlockUI.class);
    }

    public ClearScreen clearScreen() {
        return this.factory.createCommand(ClearScreen.class);
    }

    public ShowNotification showNotification() {
        return this.factory.createCommand(ShowNotification.class);
    }

    public ShowAlert showAlert() {
        return this.factory.createCommand(ShowAlert.class);
    }

    public <T> ShowDialog<T> showDialog(Class<T> valueClass) {
        return this.factory.createCommand(ShowDialog.class).withValueClass(valueClass);
    }

    public RemoveView removeView(Node view) {
        return this.factory.createCommand(RemoveView.class).withView(view);
    }
}

