/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.xcelerate.app.commands;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs.tetrabyte.xcelerate.app.commands.UICommandFactory;

public abstract class UICommand {
    private static final Logger logger = LoggerFactory.getLogger(UICommand.class);
    private UICommandFactory commandFactory;

    protected UICommand() {
    }

    abstract void validate();

    abstract String getName();

    void initialize() {
    }

    public void setCommandFactory(UICommandFactory factory) {
        this.commandFactory = factory;
    }

    public UICommandFactory getCommandFactory() {
        return this.commandFactory;
    }

    public void execute(boolean postEvent) {
        try {
            this.validate();
        }
        catch (Exception e) {
            logger.error(String.format("Command validation error. %s [ %s ].", this.getClass().getSimpleName(), e.getMessage()), (Throwable)e);
            throw e;
        }
        logger.debug(String.format("Executing UI command: %s", this));
    }

    public void execute() {
        this.execute(true);
    }

    public String toString() {
        return " " + this.getClass().getSimpleName() + " ";
    }
}

