/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.xcelerate.app.commands;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.xcelerate.app.action.Action;
import rs.tetrabyte.xcelerate.app.action.ActionBuilder;
import rs.tetrabyte.xcelerate.app.commands.UICommand;
import rs.tetrabyte.xcelerate.app.context.ScreenService;
import rs.tetrabyte.xcelerate.app.util.StringUtils;
import rs.tetrabyte.xcelerate.core.fxml.FXMLValuePair;

public class DisplayContent
extends UICommand {
    @Autowired
    private ScreenService screen;
    public static final String NAME = "display-content";
    private Node content;
    private List<ActionBuilder> actions;
    private TargetContainer target = TargetContainer.Screen;
    private boolean singleton = false;
    private boolean closable = true;
    private Callback<Void, Void> callback;

    public DisplayContent content(Node content) {
        this.content = content;
        return this;
    }

    public <C> DisplayContent fxml(FXMLValuePair<Node, C> pair) {
        Method[] methods = pair.getController().getClass().getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Action action = methods[i].getAnnotation(Action.class);
            if (action == null) continue;
            if (this.actions == null) {
                this.actions = new ArrayList<ActionBuilder>();
            }
            this.actions.add(new ActionBuilder().action(action).method(methods[i]).controller(pair.getController()));
        }
        if (this.actions != null) {
            this.actions.sort((a1, a2) -> Integer.compare(a1.getOrder(), a2.getOrder()));
        }
        return this.content(pair.getView());
    }

    @Override
    public String getName() {
        return NAME;
    }

    public DisplayContent in(TargetContainer target) {
        this.target = target;
        return this;
    }

    public DisplayContent asSingleton() {
        this.singleton = true;
        return this;
    }

    public DisplayContent closable(boolean closable) {
        this.closable = closable;
        return this;
    }

    public DisplayContent withCallback(Callback<Void, Void> callback) {
        this.callback = callback;
        return this;
    }

    public Node getContent() {
        return this.content;
    }

    public List<ActionBuilder> getActions() {
        return this.actions;
    }

    public TargetContainer getTarget() {
        return this.target;
    }

    public boolean isSingletonContent() {
        return this.singleton;
    }

    public boolean isClosable() {
        return this.closable;
    }

    public Callback<Void, Void> getCallback() {
        return this.callback;
    }

    @Override
    void validate() {
        Object messages = "";
        if (this.content == null) {
            messages = (String)messages + "Content can't be null. ";
        }
        if (this.target == null) {
            messages = (String)messages + "Target container can't be null. ";
        }
        if (!StringUtils.isEmpty((String)messages)) {
            throw new IllegalArgumentException((String)messages);
        }
    }

    @Override
    public void execute() {
        super.execute(false);
        this.screen.displayContent(this);
    }

    @Override
    public String toString() {
        return super.toString() + String.format("[ %s, target container: %s ]", this.content, this.target.name());
    }

    public static enum TargetContainer {
        Screen,
        Workarea;

    }
}

