/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.xcelerate.app.action;

import java.lang.reflect.Method;
import javafx.event.ActionEvent;
import javafx.event.EventTarget;
import javafx.scene.control.Button;
import javafx.scene.control.Tooltip;
import rs.tetrabyte.xcelerate.app.action.Action;
import rs.tetrabyte.xcelerate.app.control.XButton;

public class ActionBuilder {
    private Action action;
    private Method method;
    private Object controller;

    public ActionBuilder action(Action action) {
        this.action = action;
        return this;
    }

    public ActionBuilder method(Method method) {
        this.method = method;
        return this;
    }

    public ActionBuilder controller(Object controller) {
        this.controller = controller;
        return this;
    }

    public int getOrder() {
        return this.action.order();
    }

    public Button build() {
        XButton button = new XButton();
        button.setId(this.action.id());
        button.setButtonText(this.action.text());
        if (!this.action.accelerator().isBlank()) {
            button.setAcceleratorString(this.action.accelerator());
        }
        if (!this.action.glyph().isBlank()) {
            button.setGlyph(this.action.glyph());
        }
        if (!this.action.tooltip().isBlank()) {
            button.setTooltip(new Tooltip(this.action.tooltip()));
        }
        button.setOnAction(e -> {
            block8: {
                this.method.setAccessible(true);
                try {
                    if (this.method.getParameterCount() == 0) {
                        this.method.invoke(this.controller, new Object[0]);
                        break block8;
                    }
                    if (this.method.getParameterCount() == 1) {
                        if (this.method.getParameterTypes()[0] == ActionEvent.class) {
                            ActionEvent event = new ActionEvent((Object)button, (EventTarget)button);
                            this.method.invoke(this.controller, event);
                        }
                        break block8;
                    }
                    throw new IllegalArgumentException("Bad parameter count on action method " + ModuleLayer.Controller.class.getName() + "." + this.method.getName());
                }
                catch (Exception e1) {
                    throw new IllegalArgumentException("Failed to invoke action method", e1);
                }
                finally {
                    this.method.setAccessible(false);
                }
            }
        });
        return button;
    }
}

