/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.xcelerate.app;

import java.util.Optional;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Screen;
import javafx.util.BuilderFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import rs.tetrabyte.xcelerate.app.commands.UICommandFactory;
import rs.tetrabyte.xcelerate.app.commands.UICommands;
import rs.tetrabyte.xcelerate.app.context.AcceleratorService;
import rs.tetrabyte.xcelerate.app.context.FocusService;
import rs.tetrabyte.xcelerate.app.context.ScreenService;
import rs.tetrabyte.xcelerate.app.context.UiSettingService;
import rs.tetrabyte.xcelerate.app.context.impl.AcceleratorServiceImpl;
import rs.tetrabyte.xcelerate.app.context.impl.DefaultUiSettingProvider;
import rs.tetrabyte.xcelerate.app.context.impl.FocusServiceImpl;
import rs.tetrabyte.xcelerate.app.context.impl.LocaleContextImpl;
import rs.tetrabyte.xcelerate.app.context.impl.ScreenServiceImpl;
import rs.tetrabyte.xcelerate.app.context.impl.UiSettingServiceImpl;
import rs.tetrabyte.xcelerate.app.factory.SubScreenFactory;
import rs.tetrabyte.xcelerate.app.factory.XBuilderFactory;
import rs.tetrabyte.xcelerate.app.factory.XButtonFactory;
import rs.tetrabyte.xcelerate.core.fxml.LocaleContext;
import rs.tetrabyte.xcelerate.core.task.UIAccessor;

@Configuration
public class XApplicationConfig
implements ApplicationContextAware {
    @Value(value="${embedded:#{null}}")
    private String embedded;
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Bean
    BuilderFactory builderFactory(Optional<BuilderFactory> builderFactory) {
        return builderFactory.orElse(new XBuilderFactory());
    }

    @Bean
    XButtonFactory buttonFactory(Optional<LocaleContext> localeContext) {
        return new XButtonFactory(localeContext.orElse(new LocaleContextImpl()));
    }

    @Bean
    FocusService focusService() {
        return new FocusServiceImpl();
    }

    @Bean
    AcceleratorService acceleratorService() {
        return new AcceleratorServiceImpl();
    }

    @Bean
    UiSettingService uiSettingService(Optional<UiSettingService.UiSettingProvider> provider) {
        return new UiSettingServiceImpl(provider.orElse(new DefaultUiSettingProvider()));
    }

    @Bean
    SubScreenFactory subScreenFactory(XButtonFactory buttonFactory, UiSettingService uiSettingService) {
        return new SubScreenFactory(buttonFactory, uiSettingService);
    }

    @Bean
    ScreenService screenService(Optional<LocaleContext> localeContext, SubScreenFactory subScreenFactory, AcceleratorService acceleratorService, FocusService focusService, UIAccessor uiAccessor) {
        ScreenServiceImpl screenService = new ScreenServiceImpl(localeContext.orElse(new LocaleContextImpl()), subScreenFactory, acceleratorService, focusService);
        ((ScreenLockManager)uiAccessor).setScreenService(screenService);
        return screenService;
    }

    @Bean
    Scene scene(ScreenService screenService, AcceleratorService acceleratorService, FocusService focusService) {
        Scene scene;
        if (this.embedded != null && this.embedded.length() > 0) {
            Rectangle2D bounds = Screen.getPrimary().getBounds();
            scene = new Scene((Parent)((ScreenServiceImpl)screenService).getScreen(), bounds.getWidth(), bounds.getHeight());
        } else {
            scene = new Scene((Parent)((ScreenServiceImpl)screenService).getScreen(), 1024.0, 768.0);
        }
        ((AcceleratorServiceImpl)acceleratorService).setScene(scene);
        ((FocusServiceImpl)focusService).setScene(scene);
        scene.getStylesheets().add((Object)"/rs/tetrabyte/xcelerate/app/x.css");
        return scene;
    }

    @Bean
    UICommandFactory uiCommandFactory() {
        return new UICommandFactory(this.applicationContext.getAutowireCapableBeanFactory());
    }

    @Bean
    UICommands uiCommands(UICommandFactory uiCommandFactory) {
        return new UICommands(uiCommandFactory);
    }

    @Bean
    UIAccessor uiAccessor() {
        return new ScreenLockManager();
    }

    private static class ScreenLockManager
    implements UIAccessor {
        private ScreenServiceImpl screenService;

        private ScreenLockManager() {
        }

        void setScreenService(ScreenService screenService) {
            this.screenService = (ScreenServiceImpl)screenService;
        }

        public void lockUI() {
            if (this.screenService != null) {
                this.screenService.getScreen().lock();
            }
        }

        public void unlockUI() {
            if (this.screenService != null) {
                this.screenService.getScreen().unlock();
            }
        }
    }
}

