/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.xcelerate.core.task;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import rs.tetrabyte.xcelerate.core.task.annotation.ExceptionHandler;
import rs.tetrabyte.xcelerate.core.task.annotation.HandleException;

public class DefaultExceptionHandler
implements rs.tetrabyte.xcelerate.core.task.ExceptionHandler {
    private ApplicationContext applicationContext;

    public DefaultExceptionHandler(ApplicationContext applicationContext2) {
        this.applicationContext = applicationContext2;
    }

    @Override
    public void handle(Throwable exception) {
        Map beans = this.applicationContext.getBeansWithAnnotation(ExceptionHandler.class);
        boolean handlerInvoked = false;
        for (Map.Entry e : beans.entrySet()) {
            Object handler = e.getValue();
            Class<?> clazz = handler.getClass();
            Method[] methods = clazz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Class<?> paramType;
                Method method = methods[i];
                if (!method.canAccess(handler) || method.getParameterCount() != 1 || method.getAnnotation(HandleException.class) == null || !(paramType = method.getParameters()[0].getType()).isAssignableFrom(exception.getClass())) continue;
                try {
                    method.invoke(handler, exception);
                    handlerInvoked = true;
                    continue;
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e1) {
                    e1.printStackTrace();
                }
            }
        }
        if (!handlerInvoked) {
            exception.printStackTrace();
        }
    }
}

