/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.xcelerate.core.task;

import java.util.function.Consumer;
import javafx.concurrent.Task;
import rs.tetrabyte.xcelerate.core.task.ExceptionHandler;
import rs.tetrabyte.xcelerate.core.task.Job;
import rs.tetrabyte.xcelerate.core.task.UIAccessor;

public abstract class AbstractTask<V>
extends Task<V> {
    private boolean lockUI;
    private UIAccessor uiAccessor;
    protected Consumer<Throwable> onFailed;
    private ExceptionHandler exceptionHandler;

    public AbstractTask(ExceptionHandler exceptionHandler, UIAccessor uiAccessor) {
        this.uiAccessor = uiAccessor;
        this.lockUI = true;
        this.exceptionHandler = exceptionHandler;
        this.setOnFailed(e -> {
            if (this.lockUI) {
                uiAccessor.unlockUI();
            }
            this.onFailed(this.getException());
        });
    }

    private void onFailed(Throwable exception) {
        if (this.onFailed != null) {
            this.onFailed.accept(exception);
        } else {
            this.exceptionHandler.handle(exception);
        }
    }

    public <T extends AbstractTask<V>> T lockUI(boolean value) {
        this.lockUI = value;
        return (T)((Object)this);
    }

    public <T extends AbstractTask<V>> T uiAccessor(UIAccessor uiAccessor) {
        this.uiAccessor = uiAccessor;
        return (T)((Object)this);
    }

    public <I, T extends AbstractTask<V>> T withInput(I input) {
        return (T)((Object)this);
    }

    protected V call() throws Exception {
        return this.doInBackground();
    }

    protected abstract V doInBackground() throws Exception;

    public <T extends AbstractTask<V>> T whenDone(Consumer<V> done) {
        this.setOnSucceeded(e -> {
            try {
                if (this.lockUI && this.uiAccessor != null) {
                    this.uiAccessor.unlockUI();
                }
                Object v = this.getValue();
                if (done != null) {
                    done.accept(v);
                }
                this.finalize(v);
            }
            catch (Exception e1) {
                this.exceptionHandler.handle(e1);
            }
        });
        return (T)((Object)this);
    }

    public void execute(Consumer<V> done) {
        ((AbstractTask)((Object)this.whenDone(done))).execute();
    }

    public <T extends AbstractTask<V>> T ifFailed(Consumer<Throwable> failed) {
        this.onFailed = failed;
        return (T)((Object)this);
    }

    public void execute() {
        if (this.lockUI && this.uiAccessor != null) {
            this.uiAccessor.lockUI();
        }
        Thread t = new Thread((Runnable)((Object)this));
        t.setDaemon(false);
        t.start();
    }

    public Job join(AbstractTask<?> task) {
        return new Job(this.uiAccessor).join(this, task);
    }

    protected void finalize(V v) {
    }
}

