/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.xcelerate.core.fxml;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.util.Callback;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import rs.tetrabyte.xcelerate.core.fxml.ControllerFactory;
import rs.tetrabyte.xcelerate.core.fxml.ControllerMethodException;
import rs.tetrabyte.xcelerate.core.fxml.FXMLController;
import rs.tetrabyte.xcelerate.core.fxml.FXMLLoaderFactory;
import rs.tetrabyte.xcelerate.core.fxml.FXMLValuePair;
import rs.tetrabyte.xcelerate.core.fxml.Output;
import rs.tetrabyte.xcelerate.core.fxml.PostLoad;
import rs.tetrabyte.xcelerate.core.fxml.Wrapper;
import rs.tetrabyte.xcelerate.core.fxml.annotation.FXMLView;
import rs.tetrabyte.xcelerate.core.task.AbstractTask;
import rs.tetrabyte.xcelerate.core.task.ExceptionHandler;
import rs.tetrabyte.xcelerate.core.task.UIAccessor;

public class FXMLTask<V extends Node, C>
extends AbstractTask<FXMLValuePair<V, C>> {
    private static Logger LOGGER = LoggerFactory.getLogger(FXMLTask.class);
    private Callback<FXMLLoader, Void> beforeLoad;
    private Output output = new Output();
    private FXMLLoaderFactory fxmlLoaderFactory;
    private String fxml;
    private Class<?> controllerClass;
    private FXMLLoader loader;
    private ControllerFactory controllerFactory;
    private List<Wrapper<Node>> wrappers;

    FXMLTask(String fxml, Class<?> controllerClass, FXMLLoaderFactory fxmlLoaderFactory, ControllerFactory controllerFactory, ExceptionHandler exceptionHandler, UIAccessor uiAccessor) {
        super(exceptionHandler, uiAccessor);
        this.fxmlLoaderFactory = fxmlLoaderFactory;
        this.fxml = fxml;
        this.controllerClass = controllerClass;
        this.controllerFactory = controllerFactory;
    }

    @Override
    protected FXMLValuePair<V, C> doInBackground() throws Exception {
        FXMLView fxmlView;
        this.loader = !StringUtils.isEmpty((Object)this.fxml) ? (this.controllerFactory != null ? this.fxmlLoaderFactory.createLoader(this.fxml, this.controllerClass, this.controllerFactory, this.output) : this.fxmlLoaderFactory.createLoader(this.fxml, this.controllerClass, this.output)) : (this.controllerFactory != null ? this.fxmlLoaderFactory.createLoader(this.controllerClass, this.controllerFactory, this.output) : this.fxmlLoaderFactory.createLoader(this.controllerClass, this.output));
        if (this.beforeLoad != null) {
            Platform.runLater(() -> this.beforeLoad.call((Object)this.loader));
        }
        Node view = (Node)this.loader.load();
        Object controller = this.loader.getController();
        List<Wrapper<Node>> controllerLevelWrappers = this.getWrappersFromAnnotation(this.controllerClass);
        if (controller instanceof FXMLController) {
            if (controllerLevelWrappers != null) {
                for (Wrapper<Node> wrapper : controllerLevelWrappers) {
                    view = wrapper.wrap(view);
                }
            }
            ((FXMLController)controller).setRootNode(view);
        }
        if (this.wrappers != null) {
            for (Wrapper<Node> wrapper : this.wrappers) {
                view = wrapper.wrap(view);
            }
        }
        if ((fxmlView = controller.getClass().getAnnotation(FXMLView.class)) != null) {
            LOGGER.debug("FXML view loaded: " + fxmlView.value());
        } else {
            LOGGER.debug("FXML view loaded: " + this.fxml);
        }
        return new FXMLValuePair<Node, Object>(view, controller);
    }

    private List<Wrapper<Node>> getWrappersFromAnnotation(Class<?> controllerClass) {
        FXMLView fxmlView = controllerClass.getAnnotation(FXMLView.class);
        if (fxmlView == null) {
            return null;
        }
        ArrayList<Wrapper<Node>> wrappers = new ArrayList<Wrapper<Node>>();
        for (Class<? extends Wrapper<? extends Node>> wrapper : fxmlView.wrappers()) {
            if (this.controllerFactory != null) {
                wrappers.add((Wrapper)this.controllerFactory.create(wrapper, null));
                continue;
            }
            try {
                wrappers.add(wrapper.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not instantiate wrapper: " + wrapper.getName(), e);
            }
        }
        return wrappers;
    }

    public FXMLTask<V, C> beforeLoad(Callback<FXMLLoader, Void> beforeLoad) {
        this.beforeLoad = beforeLoad;
        return this;
    }

    public FXMLTask<V, C> output(Output output) {
        this.output.and(output);
        return this;
    }

    FXMLTask<V, C> parentOutput(Output output) {
        this.output.andParent(output);
        return this;
    }

    public FXMLTask<V, C> output(Object ... vals) {
        this.output.and(Output.values(vals));
        return this;
    }

    public FXMLTask<V, C> parent(Object parentController) {
        this.output.and(parentController);
        return this;
    }

    public <T extends Node> FXMLTask<T, C> forType(Class<T> type) {
        return this;
    }

    public <P extends Node> FXMLTask<P, C> wrap(Wrapper<P> wrapper) {
        if (this.wrappers == null) {
            this.wrappers = new ArrayList<Wrapper<Node>>();
        }
        this.wrappers.add(wrapper);
        return this;
    }

    @Override
    protected void finalize(FXMLValuePair<V, C> pair) {
        pair.getView().applyCss();
        if (pair.getController() instanceof PostLoad) {
            ((PostLoad)pair.getController()).postLoad();
        }
        for (Method method : this.getAllMethods(pair.getController())) {
            if (!method.isAnnotationPresent(PostConstruct.class)) continue;
            try {
                method.setAccessible(true);
                Object[] params = this.output.getMethodParams(method);
                method.invoke(pair.getController(), params);
                method.setAccessible(false);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new ControllerMethodException(pair.getController().getClass(), method, e);
            }
        }
    }

    private <T> List<Method> getAllMethods(T t) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Class<?> clazz = t.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (methods.stream().filter(m -> this.equalMethods((Method)m, method)).findAny().isPresent()) continue;
                methods.add(method);
            }
        }
        return methods;
    }

    private boolean equalMethods(Method m1, Method m2) {
        if (m1.getName() == m2.getName()) {
            if (!m1.getReturnType().equals(m2.getReturnType())) {
                return false;
            }
            return this.equalParamTypes(m1.getParameterTypes(), m2.getParameterTypes());
        }
        return false;
    }

    private boolean equalParamTypes(Class<?>[] params1, Class<?>[] params2) {
        if (params1.length == params2.length) {
            for (int i = 0; i < params1.length; ++i) {
                if (params1[i] == params2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.loader != null) {
            return "FXMLTask [location=" + this.loader.getLocation() + "]";
        }
        return "FXMLTask [ Unknown ]";
    }
}

