/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.xcelerate.core.fxml;

import java.net.URL;
import javafx.fxml.FXMLLoader;
import javafx.util.BuilderFactory;
import org.springframework.util.Assert;
import rs.tetrabyte.xcelerate.core.fxml.ControllerFactory;
import rs.tetrabyte.xcelerate.core.fxml.LocaleContext;
import rs.tetrabyte.xcelerate.core.fxml.Output;
import rs.tetrabyte.xcelerate.core.fxml.annotation.FXMLView;

public class FXMLLoaderFactory {
    private LocaleContext localeContext;
    private BuilderFactory builderFactory;
    private ControllerFactory controllerFactory;

    public FXMLLoaderFactory(LocaleContext localeContext, BuilderFactory builderFactory, ControllerFactory controllerFactory) {
        this.localeContext = localeContext;
        this.builderFactory = builderFactory;
        this.controllerFactory = controllerFactory;
    }

    ControllerFactory getControllerFactory() {
        return this.controllerFactory;
    }

    public FXMLLoader createLoader(String fxml, Object controller) {
        this.validate(fxml);
        URL location = controller.getClass().getResource(fxml);
        FXMLLoader fxmlLoader = new FXMLLoader(location, this.localeContext != null ? this.localeContext.getResources() : null, this.builderFactory);
        fxmlLoader.setController(controller);
        return fxmlLoader;
    }

    public FXMLLoader createLoader(String fxml, Class<?> controllerClass, ControllerFactory factory, Output output) {
        this.validate(controllerClass);
        return this.createLoader(fxml, factory.create(controllerClass, output));
    }

    public FXMLLoader createLoader(String fxml, Class<?> controllerClass, Output output) {
        this.validate(controllerClass);
        return this.createLoader(fxml, controllerClass, this.controllerFactory, output);
    }

    public FXMLLoader createLoader(Class<?> controllerClass, ControllerFactory factory, Output output) {
        this.validate(controllerClass);
        return this.createLoader(controllerClass.getAnnotation(FXMLView.class).value(), controllerClass, factory, output);
    }

    public FXMLLoader createLoader(Class<?> controllerClass, Output output) {
        this.validate(controllerClass);
        return this.createLoader(controllerClass.getAnnotation(FXMLView.class).value(), controllerClass, this.controllerFactory, output);
    }

    private void validate(String fxml) {
        Assert.hasLength((String)fxml, (String)"FXML file must be defined");
    }

    private void validate(Class<?> controllerClass) {
        Assert.notNull(controllerClass, (String)"Controller class can't be null");
        Assert.notNull((Object)controllerClass.getAnnotation(FXMLView.class), (String)String.format("Class %s must be annotated with @%s", controllerClass.getName(), FXMLView.class.getSimpleName()));
    }
}

