/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.util;

import java.awt.AWTException;
import java.awt.Robot;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.event.EventHandler;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.apache.commons.lang3.StringUtils;

public class ControlUtil {
    private static Robot eventRobot;
    private static String ACCELERATOR_PATTERN;

    public static void transferFocusOnEnter(Control control) {
        control.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent KV) {
                if (KV.getCode() == KeyCode.ENTER && !(KV.getTarget() instanceof TextArea)) {
                    eventRobot.keyPress(9);
                    eventRobot.keyRelease(9);
                    KV.consume();
                }
            }
        });
    }

    public static void transferFocusOnEnter(Control ... controls) {
        for (int i = 0; i < controls.length; ++i) {
            ControlUtil.transferFocusOnEnter(controls[i]);
        }
    }

    public static void transferFocusOnArrowKeys(Control control) {
        control.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent KV) {
                if (KV.getTarget() instanceof TextArea) {
                    return;
                }
                if (KV.getCode() == KeyCode.UP) {
                    eventRobot.keyPress(16);
                    eventRobot.keyPress(9);
                    eventRobot.keyRelease(9);
                    eventRobot.keyRelease(16);
                    KV.consume();
                } else if (KV.getCode() == KeyCode.DOWN) {
                    eventRobot.keyPress(9);
                    eventRobot.keyRelease(9);
                    KV.consume();
                }
            }
        });
    }

    public static void transferFocusOnArrowKeys(Control ... controls) {
        for (int i = 0; i < controls.length; ++i) {
            ControlUtil.transferFocusOnArrowKeys(controls[i]);
        }
    }

    public static TextFormatter getDecimalTextFormatter() {
        UnaryOperator<TextFormatter.Change> filter = new UnaryOperator<TextFormatter.Change>(){

            @Override
            public TextFormatter.Change apply(TextFormatter.Change t) {
                if (t.isContentChange()) {
                    System.out.println("Text: " + t.getText());
                    System.out.println("ControlText: " + t.getControlText());
                    System.out.println("ControlNewText: " + t.getControlNewText());
                }
                return t;
            }
        };
        return new TextFormatter((UnaryOperator)filter);
    }

    public static void transferFocusOnUpArrow(Control control) {
        try {
            control.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){
                Robot eventRobot = new Robot();

                public void handle(KeyEvent KV) {
                    if (KV.getTarget() instanceof TextArea) {
                        return;
                    }
                    if (KV.getCode() == KeyCode.UP) {
                        this.eventRobot.keyPress(16);
                        this.eventRobot.keyPress(9);
                        this.eventRobot.keyRelease(9);
                        this.eventRobot.keyRelease(16);
                        KV.consume();
                    }
                }
            });
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
    }

    public static void transferFocusOnDownArrow(Control control) {
        try {
            control.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){
                Robot eventRobot = new Robot();

                public void handle(KeyEvent KV) {
                    if (KV.getTarget() instanceof TextArea) {
                        return;
                    }
                    if (KV.getCode() == KeyCode.DOWN) {
                        this.eventRobot.keyPress(9);
                        this.eventRobot.keyRelease(9);
                        KV.consume();
                    }
                }
            });
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
    }

    public static void fireButtonOnEnter(Control control, final Button button) {
        control.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent KV) {
                if (KV.getCode() == KeyCode.ENTER && !(KV.getTarget() instanceof TextArea)) {
                    button.fire();
                    KV.consume();
                }
            }
        });
    }

    public static void executeOnEnter(Control control, final Runnable runnable) {
        control.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent KV) {
                if (KV.getCode() == KeyCode.ENTER && !(KV.getTarget() instanceof TextArea)) {
                    runnable.run();
                    KV.consume();
                }
            }
        });
    }

    public static String[] parseAcceleratedLabel(String text) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return new String[]{""};
        }
        String[] parsed = new String[3];
        Matcher m = Pattern.compile(ACCELERATOR_PATTERN).matcher(text);
        if (m.find()) {
            parsed[0] = m.group(1);
            if (m.groupCount() > 1 && m.group(2) != null) {
                parsed[1] = m.group(2);
            }
            if (m.groupCount() > 2 && m.group(3) != null) {
                parsed[2] = m.group(3).replaceAll("\\{|\\}", "");
            }
        } else {
            parsed[0] = text;
        }
        return parsed;
    }

    static {
        ACCELERATOR_PATTERN = "(.+)\\[(.+?)\\]\\s*(\\{.+?\\})?";
        try {
            eventRobot = new Robot();
        }
        catch (AWTException e) {
            eventRobot = null;
            e.printStackTrace();
        }
    }
}

