/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.service;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.modelmapper.AbstractConverter;
import org.modelmapper.Converter;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import rs.tetrabyte.pos.dao.InvoiceDAO;
import rs.tetrabyte.pos.dao.InvoiceItemDAO;
import rs.tetrabyte.pos.dao.Page;
import rs.tetrabyte.pos.model.entity.Invoice;
import rs.tetrabyte.pos.model.entity.InvoiceItem;
import rs.tetrabyte.pos.model.view.InvoiceItemView;
import rs.tetrabyte.pos.model.view.InvoiceView;
import rs.tetrabyte.pos.sdc.InvoiceTransaction;
import rs.tetrabyte.pos.sdc.SDCException;
import rs.tetrabyte.pos.sdc.model.InvoiceResponse;
import rs.tetrabyte.pos.service.SDCService;

@Service
public class InvoiceService {
    @Autowired
    private InvoiceDAO invoiceDao;
    @Autowired
    private InvoiceItemDAO invoiceItemDao;
    @Autowired
    private SDCService sdcService;
    private final ModelMapper mapper = new ModelMapper();

    public InvoiceService() {
        this.mapper.typeMap(Invoice.class, InvoiceView.class).addMappings(mapper -> mapper.using(this.getInvoiceItemToInvoiceItemViewConverter()).map(Invoice::getItems, InvoiceView::setItems));
    }

    @Transactional
    public void addInvoice(InvoiceView invoiceView) throws SDCException {
        InvoiceResponse response = this.sdcService.createInvoice(invoiceView);
        invoiceView.setSdcDateTime(LocalDateTime.parse(response.getEntity().getSdcDateTime()));
        invoiceView.setSdcNumber(response.getEntity().getInvoiceNumber());
        Invoice invoice = (Invoice)this.mapper.map((Object)invoiceView, Invoice.class);
        invoice.updateTotal();
        invoice.getItems().forEach(item -> item.setInvoice(invoice));
        if (invoice.getCustomer() != null && invoice.getCustomer().getId() == null) {
            invoice.setCustomer(null);
        }
        this.invoiceDao.saveInvoice(invoice);
        this.invoiceItemDao.saveInvoiceItems(invoice.getItems());
    }

    public Page<InvoiceView> getAllInvoices(int pageSize, int pageNumber) {
        return this.mapPage(this.invoiceDao.getAllInvoices(pageSize, pageNumber));
    }

    public long getInvoiceCount() {
        return this.invoiceDao.getInvoiceCount();
    }

    public Optional<InvoiceView> findInvoiceById(UUID id) {
        return this.invoiceDao.getInvoiceById(id).map(invoice -> (InvoiceView)this.mapper.map(invoice, InvoiceView.class));
    }

    private List<InvoiceView> mapList(List<Invoice> invoices) {
        return invoices.stream().map(i -> (InvoiceView)this.mapper.map(i, InvoiceView.class)).collect(Collectors.toList());
    }

    private Converter<List<InvoiceItem>, List<InvoiceItemView>> getInvoiceItemToInvoiceItemViewConverter() {
        return new AbstractConverter<List<InvoiceItem>, List<InvoiceItemView>>(){

            public List<InvoiceItemView> convert(List<InvoiceItem> source) {
                if (source == null) {
                    return null;
                }
                return source.stream().map(invoiceItem -> {
                    InvoiceItemView view = (InvoiceItemView)InvoiceService.this.mapper.map(invoiceItem, InvoiceItemView.class);
                    return view;
                }).collect(Collectors.toList());
            }
        };
    }

    private Page<InvoiceView> mapPage(Page<Invoice> page) {
        return new Page<InvoiceView>(page.getPageSize(), page.getPageCount(), page.getPageNumber(), page.getTotalCount(), this.mapList(page.getData()));
    }

    public Page<InvoiceView> searchInvoices(String searchString, int pageSize, int pageNumber) {
        return this.mapPage(this.invoiceDao.searchInvoices(searchString, pageSize, pageNumber));
    }

    public ObservableList<InvoiceView> filterInvoicesById(ObservableList<InvoiceView> invoices, String idText) {
        if (idText == null || idText.isEmpty()) {
            return invoices;
        }
        ObservableList filteredInvoices = FXCollections.observableArrayList();
        for (InvoiceView invoice : invoices) {
            if (!invoice.getId().toString().contains(idText)) continue;
            filteredInvoices.add((Object)invoice);
        }
        return filteredInvoices;
    }

    public Page<InvoiceView> getInvoicesByDateAndType(LocalDate startDate, LocalDate endDate, InvoiceTransaction type, int pageSize, int pageIndex) {
        return this.mapPage(this.invoiceDao.getInvoicesByDateAndType(startDate, endDate, type, pageSize, pageIndex));
    }

    public Page<InvoiceView> getInvoicesByType(InvoiceTransaction type, int pageSize, int pageNumber) {
        return this.mapPage(this.invoiceDao.getInvoicesByType(type, pageSize, pageNumber));
    }
}

