/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import rs.tetrabyte.pos.dao.InvoiceItemDAO;
import rs.tetrabyte.pos.model.entity.InvoiceItem;
import rs.tetrabyte.pos.model.view.InvoiceItemView;
import rs.tetrabyte.pos.model.view.InvoiceView;
import rs.tetrabyte.pos.model.view.ItemView;
import rs.tetrabyte.pos.util.ObservableArrayListProperty;
import rs.tetrabyte.xcelerate.core.task.AbstractTask;
import rs.tetrabyte.xcelerate.core.task.TaskFactory;
import rs.tetrabyte.xcelerate.core.task.UIAccessor;

@Service
public class InvoiceItemService {
    @Autowired
    private InvoiceItemDAO invoiceItemDao;
    private TaskFactory taskFactory;
    private UIAccessor uiAccessor;
    private ObservableArrayListProperty<InvoiceItemView> invoiceItems = new ObservableArrayListProperty();
    private ModelMapper mapper = new ModelMapper();

    public InvoiceItemService(TaskFactory taksFactory) {
        this.taskFactory = taksFactory;
    }

    private List<InvoiceItemView> getInvoiceItems() {
        return this.invoiceItemDao.getInvoiceItems().stream().map(v -> (InvoiceItemView)this.mapper.map(v, InvoiceItemView.class)).collect(Collectors.toList());
    }

    public void setUiAccessor(UIAccessor uiAccessor) {
        this.uiAccessor = uiAccessor;
    }

    public void loadInvoiceItemsAsync() {
        this.taskFactory.createTask(this::getInvoiceItems).execute(arg_0 -> ((ObservableList)((ObservableList)this.invoiceItems.get())).setAll(arg_0));
    }

    public synchronized void addItemToInvoiceAsync(ItemView view, BigDecimal price, BigDecimal quantity) {
        ((ObservableList)this.invoiceItems.get()).stream().filter(i -> i.getItemId().equals(view.getId()) && i.getPrice().equals(price)).findFirst().ifPresentOrElse(i -> ((AbstractTask)((Object)((Object)this.taskFactory.createTask(() -> {
            this.invoiceItemDao.incInvoiceItemQuantity(view.getId(), price, quantity);
            return null;
        }).uiAccessor(this.uiAccessor)))).execute(a -> {
            i.setQuantity(i.getQuantity().add(quantity));
            i.setTotal(i.getQuantity().multiply(i.getPrice()).setScale(2, RoundingMode.HALF_UP));
            ((ObservableList)this.invoiceItems.get()).set(((ObservableList)this.invoiceItems.get()).indexOf(i), i);
        }), () -> ((AbstractTask)((Object)((Object)this.taskFactory.createTask(() -> {
            InvoiceItemView invoiceItemView = (InvoiceItemView)this.mapper.map((Object)view, InvoiceItemView.class);
            invoiceItemView.setQuantity(quantity);
            if (price != null) {
                invoiceItemView.setPrice(price);
            }
            invoiceItemView.setTotal(invoiceItemView.getQuantity().multiply(invoiceItemView.getPrice()).setScale(2, RoundingMode.HALF_UP));
            InvoiceItem invoiceItem = (InvoiceItem)this.mapper.map((Object)invoiceItemView, InvoiceItem.class);
            invoiceItem = this.invoiceItemDao.addInvoiceItem(invoiceItem);
            return invoiceItem;
        }).uiAccessor(this.uiAccessor)))).execute(invoiceItem -> ((ObservableList)this.invoiceItems.get()).add((Object)((InvoiceItemView)this.mapper.map(invoiceItem, InvoiceItemView.class)))));
    }

    public void addItemToInvoiceAsync(ItemView view) {
        this.addItemToInvoiceAsync(view, view.getPrice(), BigDecimal.ONE);
    }

    public void removeItemFromInvoiceAsync(InvoiceItemView view) {
        if (view == null) {
            return;
        }
        ((AbstractTask)((Object)this.taskFactory.createTask(() -> this.invoiceItemDao.removeInvoiceItem(view.getId())).uiAccessor(this.uiAccessor))).execute(optional -> {
            if (optional.isPresent()) {
                ((ObservableList)this.invoiceItems.get()).remove((Object)view);
            }
        });
    }

    public void incInvoiceItemQuantityASync(InvoiceItemView itemView, BigDecimal quantity) {
        if (itemView == null) {
            return;
        }
        ((AbstractTask)((Object)this.taskFactory.createTask(() -> {
            this.invoiceItemDao.incInvoiceItemQuantity(itemView.getItemId(), itemView.getPrice(), itemView.getQuantity());
            return null;
        }).uiAccessor(this.uiAccessor))).execute(a -> ((ObservableList)this.invoiceItems.get()).stream().filter(i -> i.getItemId().equals(itemView.getItemId()) && i.getPrice().equals(itemView.getPrice())).findFirst().ifPresent(i -> {
            i.setQuantity(i.getQuantity().add(quantity));
            i.setTotal(i.getQuantity().multiply(i.getPrice()));
            ((ObservableList)this.invoiceItems.get()).set(((ObservableList)this.invoiceItems.get()).indexOf(i), i);
        }));
    }

    public void removeAllItemsFromInvoiceAsync() {
        this.taskFactory.createTask(() -> {
            this.invoiceItemDao.removeAllInvoiceItems();
            return null;
        }).execute(a -> ((ObservableList)this.invoiceItems.get()).clear());
    }

    public ObservableArrayListProperty<InvoiceItemView> invoiceItemsProperty() {
        return this.invoiceItems;
    }

    public void updateInvoiceItem(InvoiceItemView selectedItem) {
        selectedItem.setTotal(selectedItem.getQuantity().multiply(selectedItem.getPrice()).setScale(2, RoundingMode.HALF_UP));
        ((AbstractTask)((Object)this.taskFactory.createTask(() -> this.invoiceItemDao.updateInvoiceItem((InvoiceItem)this.mapper.map((Object)selectedItem, InvoiceItem.class))).uiAccessor(this.uiAccessor))).execute(invoiceItem -> ((ObservableList)this.invoiceItems.get()).stream().filter(i -> i.getId().equals(selectedItem.getId())).findFirst().ifPresent(i -> {
            InvoiceItemView updatedInvoiceItem = (InvoiceItemView)this.mapper.map(invoiceItem, InvoiceItemView.class);
            ((ObservableList)this.invoiceItems.get()).set(((ObservableList)this.invoiceItems.get()).indexOf(i), (Object)updatedInvoiceItem);
        }));
    }

    public List<InvoiceItemView> getInvoiceItemsByInvoice(InvoiceView invoiceView) {
        return this.invoiceItemDao.findByInvoiceId(invoiceView.getId()).stream().map(v -> (InvoiceItemView)this.mapper.map(v, InvoiceItemView.class)).collect(Collectors.toList());
    }
}

