/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.service;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import rs.tetrabyte.pos.dao.DailyReportDAO;
import rs.tetrabyte.pos.dao.Page;
import rs.tetrabyte.pos.model.entity.DailyReport;
import rs.tetrabyte.pos.model.view.DailyReportView;
import rs.tetrabyte.pos.sdc.SDCException;
import rs.tetrabyte.pos.sdc.model.report.Report;
import rs.tetrabyte.pos.service.SDCService;

@Service
public class DailyReportService {
    @Autowired
    private DailyReportDAO reportDao;
    @Autowired
    private SDCService sdcService;
    private ModelMapper mapper = new ModelMapper();

    public List<String> findAllUids() {
        return this.reportDao.findAllUids();
    }

    public Page<DailyReportView> findAll(String uid, LocalDateTime startDateTime, LocalDateTime endDateTime, int pageNumber, int pageSize) {
        return this.mapPage(this.reportDao.findAll(uid, startDateTime, endDateTime, pageNumber, pageSize));
    }

    public DailyReportView saveReport(Report report) {
        DailyReportView view = new DailyReportView();
        view.setData(report);
        view.setUid(report.getUid());
        view.setDateTime(LocalDateTime.parse(report.getDateTime()));
        view.setTotal(report.getTotal().getPayments().stream().map(a -> a.getAmount()).reduce(BigDecimal.ZERO, (a, b) -> a.add((BigDecimal)b)));
        view.setNumber(report.getNumber());
        return this.saveReport(view);
    }

    public DailyReportView saveReport(DailyReportView view) {
        DailyReport report = this.reportDao.saveReport((DailyReport)this.mapper.map((Object)view, DailyReport.class));
        return (DailyReportView)this.mapper.map((Object)report, DailyReportView.class);
    }

    public DailyReportView closeDay() throws SDCException {
        this.sdcService.attention();
        Report report = this.sdcService.printDailyReport(true);
        return this.saveReport(report);
    }

    private List<DailyReportView> mapList(List<DailyReport> customers) {
        return customers.stream().map(c -> (DailyReportView)this.mapper.map(c, DailyReportView.class)).collect(Collectors.toList());
    }

    private Page<DailyReportView> mapPage(Page<DailyReport> page) {
        return new Page<DailyReportView>(page.getPageSize(), page.getPageCount(), page.getPageNumber(), page.getTotalCount(), this.mapList(page.getData()));
    }
}

