/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.service;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import rs.tetrabyte.pos.dao.CustomerDAO;
import rs.tetrabyte.pos.dao.Page;
import rs.tetrabyte.pos.model.entity.Customer;
import rs.tetrabyte.pos.model.entity.CustomerType;
import rs.tetrabyte.pos.model.view.CustomerView;
import rs.tetrabyte.xcelerate.core.task.AbstractTask;
import rs.tetrabyte.xcelerate.core.task.TaskFactory;
import rs.tetrabyte.xcelerate.core.task.UIAccessor;

@Service
public class CustomerService {
    @Autowired
    private CustomerDAO customerDao;
    @Autowired
    private TaskFactory taskFactory;
    @Autowired
    private UIAccessor uiAccessor;
    private final ModelMapper mapper = new ModelMapper();

    public void addCustomer(CustomerView customerView) {
        Customer customer = (Customer)this.mapper.map((Object)customerView, Customer.class);
        this.customerDao.addCustomer(customer);
    }

    public void updateCustomer(CustomerView customerView) {
        Customer customer = (Customer)this.mapper.map((Object)customerView, Customer.class);
        this.customerDao.updateCustomer(customer);
    }

    public Page<CustomerView> getAllCustomers(int pageSize, int pageNumber) {
        return this.mapPage(this.customerDao.getAllCustomers(pageSize, pageNumber));
    }

    public long getCustomerCount() {
        return this.customerDao.getCustomerCount();
    }

    public Optional<CustomerView> findCustomerByUid(String uid) {
        return this.customerDao.findCustomerByUid(uid).map(customer -> (CustomerView)this.mapper.map(customer, CustomerView.class));
    }

    private List<CustomerView> mapList(List<Customer> customers) {
        return customers.stream().map(c -> (CustomerView)this.mapper.map(c, CustomerView.class)).collect(Collectors.toList());
    }

    private Page<CustomerView> mapPage(Page<Customer> page) {
        return new Page<CustomerView>(page.getPageSize(), page.getPageCount(), page.getPageNumber(), page.getTotalCount(), this.mapList(page.getData()));
    }

    public Page<CustomerView> searchCustomers(String string, int pageSize, int pageNumber) {
        return this.mapPage(this.customerDao.searchCustomers(string, pageSize, pageNumber));
    }

    public void removeCustomerAsync(String uid, ObservableList<CustomerView> customers) {
        ((AbstractTask)((Object)this.taskFactory.createTask(() -> this.customerDao.removeCustomer(uid)).uiAccessor(this.uiAccessor))).execute(optional -> {
            if (optional.isPresent()) {
                customers.removeIf(view -> view.getUid().equals(uid));
            }
        });
    }

    public String formatCustomerType(CustomerType customerType) {
        switch (customerType) {
            case LEGAL_PERSON: {
                return "PRAVNO LICE";
            }
            case INDIVIDUAL_PERSON: {
                return "FIZI\u010cKO LICE";
            }
        }
        return "";
    }
}

