/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.service;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import rs.tetrabyte.pos.dao.CategoryDAO;
import rs.tetrabyte.pos.model.entity.Category;
import rs.tetrabyte.pos.model.view.CategoryView;
import rs.tetrabyte.xcelerate.core.task.TaskFactory;
import rs.tetrabyte.xcelerate.core.task.UIAccessor;

@Service
public class CategoryService {
    @Autowired
    private CategoryDAO categoryDao;
    @Autowired
    private TaskFactory taskFactory;
    @Autowired
    private UIAccessor uiAccessor;
    private ModelMapper mapper = new ModelMapper();

    public List<CategoryView> getAllCategories() {
        return this.mapList(this.categoryDao.getAllCategories());
    }

    public void deleteCategoryById(UUID categoryId) {
        this.categoryDao.deleteCategoryById(categoryId);
    }

    public List<CategoryView> getRootCategories() {
        return this.mapList(this.categoryDao.getRootCategories());
    }

    public List<CategoryView> getChildrenCategories(CategoryView category) {
        return this.categoryDao.getCategory(category.getId()).map(c -> this.mapList(this.categoryDao.getChildrenCategories((Category)c))).orElse(new ArrayList());
    }

    private List<CategoryView> mapList(List<Category> categories) {
        return categories.stream().map(c -> (CategoryView)this.mapper.map(c, CategoryView.class)).collect(Collectors.toList());
    }

    public void saveCategory(CategoryView categoryView) {
        Category category = (Category)this.mapper.map((Object)categoryView, Category.class);
        this.categoryDao.saveCategory(category);
    }

    public boolean existsByName(String name) {
        return this.categoryDao.existsByName(name);
    }
}

