/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.service;

import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.layout.StackPane;
import javafx.util.StringConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import rs.tetrabyte.pos.model.entity.ItemType;
import rs.tetrabyte.pos.model.view.CategoryView;
import rs.tetrabyte.xcelerate.app.commands.UICommands;
import rs.tetrabyte.xcelerate.core.fxml.FXMLTaskFactory;

@Service
public class ArticlesService {
    private Node showArticles;
    private StackPane parent;
    @Autowired
    private FXMLTaskFactory factory;
    private ComboBox<CategoryView> categoryComboBox;
    private ComboBox<ItemType> typeComboBox;
    @Autowired
    private UICommands uiCommands;

    public void loadCategories() {
        this.categoryComboBox.setConverter((StringConverter)new StringConverter<CategoryView>(){

            public String toString(CategoryView category) {
                return category != null ? category.getName() : "";
            }

            public CategoryView fromString(String string) {
                return null;
            }
        });
    }

    public void loadType(ComboBox<ItemType> typeComboBox) {
        typeComboBox.setCellFactory(param -> new ListCell<ItemType>(){

            protected void updateItem(ItemType item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty || item == null) {
                    this.setText(null);
                } else {
                    this.setText(ArticlesService.this.formatItemType(item));
                }
            }
        });
        typeComboBox.setConverter((StringConverter)new StringConverter<ItemType>(){

            public String toString(ItemType itemType) {
                return itemType != null ? ArticlesService.this.formatItemType(itemType) : "";
            }

            public ItemType fromString(String string) {
                return null;
            }
        });
        typeComboBox.getItems().setAll((Object[])ItemType.values());
    }

    private String formatItemType(ItemType itemType) {
        switch (itemType) {
            case PRODUCT: {
                return "Proizvod";
            }
            case SERVICE: {
                return "Usluga";
            }
        }
        return "";
    }
}

