/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.sdc.model;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import rs.tetrabyte.pos.sdc.model.InvoiceItem;
import rs.tetrabyte.pos.sdc.model.InvoicePayment;
import rs.tetrabyte.pos.sdc.model.JournalOptions;

public class InvoiceRequestEntity {
    private LocalDateTime dateAndTimeOfIssue;
    private String cashier;
    private String buyerId;
    private String buyerCostCenterId;
    private String invoiceType;
    private String transactionType;
    private String invoiceNumber;
    private String referentDocumentNumber;
    private LocalDateTime referentDocumentDT;
    private List<InvoiceItem> items;
    private List<InvoicePayment> payment;
    private JournalOptions journalOptions;

    InvoiceRequestEntity(LocalDateTime dateAndTimeOfIssue, String cashier, String buyerId, String buyerCostCenterId, String invoiceType, String transactionType, String invoiceNumber, String referentDocumentNumber, LocalDateTime referentDocumentDT, List<InvoiceItem> items, List<InvoicePayment> payment, JournalOptions journalOptions) {
        this.dateAndTimeOfIssue = dateAndTimeOfIssue;
        this.cashier = cashier;
        this.buyerId = buyerId;
        this.buyerCostCenterId = buyerCostCenterId;
        this.invoiceType = invoiceType;
        this.transactionType = transactionType;
        this.invoiceNumber = invoiceNumber;
        this.referentDocumentNumber = referentDocumentNumber;
        this.referentDocumentDT = referentDocumentDT;
        this.items = items;
        this.payment = payment;
        this.journalOptions = journalOptions;
    }

    public static InvoiceRequestEntityBuilder builder() {
        return new InvoiceRequestEntityBuilder();
    }

    public LocalDateTime getDateAndTimeOfIssue() {
        return this.dateAndTimeOfIssue;
    }

    public String getCashier() {
        return this.cashier;
    }

    public String getBuyerId() {
        return this.buyerId;
    }

    public String getBuyerCostCenterId() {
        return this.buyerCostCenterId;
    }

    public String getInvoiceType() {
        return this.invoiceType;
    }

    public String getTransactionType() {
        return this.transactionType;
    }

    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public String getReferentDocumentNumber() {
        return this.referentDocumentNumber;
    }

    public LocalDateTime getReferentDocumentDT() {
        return this.referentDocumentDT;
    }

    public List<InvoiceItem> getItems() {
        return this.items;
    }

    public List<InvoicePayment> getPayment() {
        return this.payment;
    }

    public JournalOptions getJournalOptions() {
        return this.journalOptions;
    }

    public static class InvoiceRequestEntityBuilder {
        private LocalDateTime dateAndTimeOfIssue;
        private String cashier;
        private String buyerId;
        private String buyerCostCenterId;
        private String invoiceType;
        private String transactionType;
        private String invoiceNumber;
        private String referentDocumentNumber;
        private LocalDateTime referentDocumentDT;
        private List<InvoiceItem> items;
        private List<InvoicePayment> payment;
        private JournalOptions journalOptions;

        private JournalOptions options() {
            if (this.journalOptions == null) {
                this.journalOptions = new JournalOptions();
            }
            return this.journalOptions;
        }

        public InvoiceRequestEntityBuilder advance(BigDecimal advance) {
            this.options().setAdvance(advance);
            return this;
        }

        public InvoiceRequestEntityBuilder advanceTax(BigDecimal advanceTax) {
            this.options().setAdvanceTax(advanceTax);
            return this;
        }

        public InvoiceRequestEntityBuilder message(String message) {
            this.options().appendMessage(message + "\r\n");
            return this;
        }

        InvoiceRequestEntityBuilder() {
        }

        public InvoiceRequestEntityBuilder dateAndTimeOfIssue(LocalDateTime dateAndTimeOfIssue) {
            this.dateAndTimeOfIssue = dateAndTimeOfIssue;
            return this;
        }

        public InvoiceRequestEntityBuilder cashier(String cashier) {
            this.cashier = cashier;
            return this;
        }

        public InvoiceRequestEntityBuilder buyerId(String buyerId) {
            this.buyerId = buyerId;
            return this;
        }

        public InvoiceRequestEntityBuilder buyerCostCenterId(String buyerCostCenterId) {
            this.buyerCostCenterId = buyerCostCenterId;
            return this;
        }

        public InvoiceRequestEntityBuilder invoiceType(String invoiceType) {
            this.invoiceType = invoiceType;
            return this;
        }

        public InvoiceRequestEntityBuilder transactionType(String transactionType) {
            this.transactionType = transactionType;
            return this;
        }

        public InvoiceRequestEntityBuilder invoiceNumber(String invoiceNumber) {
            this.invoiceNumber = invoiceNumber;
            return this;
        }

        public InvoiceRequestEntityBuilder referentDocumentNumber(String referentDocumentNumber) {
            this.referentDocumentNumber = referentDocumentNumber;
            return this;
        }

        public InvoiceRequestEntityBuilder referentDocumentDT(LocalDateTime referentDocumentDT) {
            this.referentDocumentDT = referentDocumentDT;
            return this;
        }

        public InvoiceRequestEntityBuilder items(List<InvoiceItem> items) {
            this.items = items;
            return this;
        }

        public InvoiceRequestEntityBuilder payment(List<InvoicePayment> payment) {
            this.payment = payment;
            return this;
        }

        public InvoiceRequestEntityBuilder journalOptions(JournalOptions journalOptions) {
            this.journalOptions = journalOptions;
            return this;
        }

        public InvoiceRequestEntity build() {
            return new InvoiceRequestEntity(this.dateAndTimeOfIssue, this.cashier, this.buyerId, this.buyerCostCenterId, this.invoiceType, this.transactionType, this.invoiceNumber, this.referentDocumentNumber, this.referentDocumentDT, this.items, this.payment, this.journalOptions);
        }

        public String toString() {
            return "InvoiceRequestEntity.InvoiceRequestEntityBuilder(dateAndTimeOfIssue=" + String.valueOf(this.dateAndTimeOfIssue) + ", cashier=" + this.cashier + ", buyerId=" + this.buyerId + ", buyerCostCenterId=" + this.buyerCostCenterId + ", invoiceType=" + this.invoiceType + ", transactionType=" + this.transactionType + ", invoiceNumber=" + this.invoiceNumber + ", referentDocumentNumber=" + this.referentDocumentNumber + ", referentDocumentDT=" + String.valueOf(this.referentDocumentDT) + ", items=" + String.valueOf(this.items) + ", payment=" + String.valueOf(this.payment) + ", journalOptions=" + String.valueOf(this.journalOptions) + ")";
        }
    }
}

