/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.sdc.model;

import rs.tetrabyte.pos.model.entity.Customer;
import rs.tetrabyte.pos.sdc.model.InvoiceRequestEntity;

public class InvoiceRequest {
    private String id;
    private InvoiceRequestEntity entity;
    private boolean copyWithSignature;
    private Customer customer;

    InvoiceRequest(String id, InvoiceRequestEntity entity, boolean copyWithSignature, Customer customer) {
        this.id = id;
        this.entity = entity;
        this.copyWithSignature = copyWithSignature;
        this.customer = customer;
    }

    public static InvoiceRequestBuilder builder() {
        return new InvoiceRequestBuilder();
    }

    public String getId() {
        return this.id;
    }

    public InvoiceRequestEntity getEntity() {
        return this.entity;
    }

    public boolean isCopyWithSignature() {
        return this.copyWithSignature;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public static class InvoiceRequestBuilder {
        private String id;
        private InvoiceRequestEntity entity;
        private boolean copyWithSignature;
        private Customer customer;

        InvoiceRequestBuilder() {
        }

        public InvoiceRequestBuilder id(String id) {
            this.id = id;
            return this;
        }

        public InvoiceRequestBuilder entity(InvoiceRequestEntity entity) {
            this.entity = entity;
            return this;
        }

        public InvoiceRequestBuilder copyWithSignature(boolean copyWithSignature) {
            this.copyWithSignature = copyWithSignature;
            return this;
        }

        public InvoiceRequestBuilder customer(Customer customer) {
            this.customer = customer;
            return this;
        }

        public InvoiceRequest build() {
            return new InvoiceRequest(this.id, this.entity, this.copyWithSignature, this.customer);
        }

        public String toString() {
            return "InvoiceRequest.InvoiceRequestBuilder(id=" + this.id + ", entity=" + String.valueOf(this.entity) + ", copyWithSignature=" + this.copyWithSignature + ", customer=" + String.valueOf(this.customer) + ")";
        }
    }
}

