/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.sdc;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import rs.tetrabyte.pos.util.DataValidator;

public class BuyerIdentification {
    public static final BuyerIdentification BEZ_IDENTIFIKACIJE = new BuyerIdentification(null, "Bez identifikacije", null);
    public static final BuyerIdentification PIB_KUPCA = new BuyerIdentification("10", "PIB kupca", "[0-9]+", DataValidator::isPIBValid);
    public static final BuyerIdentification JMBG = new BuyerIdentification("11", "JMBG", "[0-9]+", DataValidator::isJMBGValid);
    public static final BuyerIdentification PIB_JBKJS = new BuyerIdentification("12", "PIB i JBKJS", "[0-9]+\\:[0-9]+", val -> DataValidator.isPIBValid(val.split("\\:")[0]));
    public static final BuyerIdentification PENZIONERSKA_KARTICA = new BuyerIdentification("13", "Penzionerska kartica", "\\[a-zA-Z0-9]+");
    public static final BuyerIdentification PIB_POLJ_GAZDINSTVO = new BuyerIdentification("14", "PIB (polj. gazdinstvo)", "[0-9]+", DataValidator::isPIBValid);
    public static final BuyerIdentification JMBG_POLJ_GAZDINSTVO = new BuyerIdentification("15", "JMBG (polj. gazdinstvo)", "[0-9]+", DataValidator::isJMBGValid);
    public static final BuyerIdentification BPG = new BuyerIdentification("16", "BPG", "[a-zA-Z0-9]+");
    public static final BuyerIdentification BRLK = new BuyerIdentification("20", "Broj li\u010dne karte", "\\d+");
    public static final BuyerIdentification IZBEGLICKA_LEGITIMACIJA = new BuyerIdentification("21", "Broj izbegli\u010dke legitimacije", null);
    public static final BuyerIdentification EBS = new BuyerIdentification("22", "EBS", null);
    public static final BuyerIdentification PASOS_DOMACI = new BuyerIdentification("23", "Broj paso\u0161a (doma\u0107i)", "\\d+");
    public static final BuyerIdentification PASOS_STRANI = new BuyerIdentification("30", "Broj paso\u0161a (strani)", null);
    public static final BuyerIdentification DIPL_LEGITIMACIJA = new BuyerIdentification("31", "Broj dipl. legitimacije/LK", null);
    public static final BuyerIdentification BRLK_MKD = new BuyerIdentification("32", "Broj li\u010dne karte MKD", null);
    public static final BuyerIdentification BRLK_MNE = new BuyerIdentification("33", "Broj li\u010dne karte MNE", null);
    public static final BuyerIdentification BRLK_ALB = new BuyerIdentification("34", "Broj li\u010dne karte ALB", null);
    public static final BuyerIdentification BRLK_BIH = new BuyerIdentification("35", "Broj li\u010dne karte BIH", null);
    public static final BuyerIdentification TIN = new BuyerIdentification("40", "Poreski ID strane dr\u017eave", null);
    private String id;
    private String label;
    private String regex;
    private List<Function<String, Boolean>> validators;

    public BuyerIdentification(String id, String label, String regex, Function<String, Boolean> val) {
        this.id = id;
        this.label = label;
        this.validators = new ArrayList<Function<String, Boolean>>();
        if (regex != null) {
            this.validators.add(v -> Pattern.compile(regex).matcher((CharSequence)v).matches());
        }
        if (val != null) {
            this.validators.add(val);
        }
    }

    public BuyerIdentification(String id, String label, String regex) {
        this(id, label, regex, null);
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getRegex() {
        return this.regex;
    }

    public String value(String val) {
        if (this.id == null || val.isBlank()) {
            return null;
        }
        return this.id + ":" + val;
    }

    public boolean isValid(String value) {
        if (this.validators.size() == 0) {
            return true;
        }
        return this.validators.stream().map(v -> (Boolean)v.apply(value)).reduce(Boolean.TRUE, (a, b) -> a != false && b != false);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.label);
        if (this.id != null) {
            sb.append(" ").append("[").append(this.id).append("]");
        }
        return sb.toString();
    }

    public static BuyerIdentification[] getAll() {
        return new BuyerIdentification[]{BEZ_IDENTIFIKACIJE, PIB_KUPCA, JMBG, PIB_JBKJS, PENZIONERSKA_KARTICA, PIB_POLJ_GAZDINSTVO, JMBG_POLJ_GAZDINSTVO, BPG, BRLK, IZBEGLICKA_LEGITIMACIJA, EBS, PASOS_DOMACI, PASOS_STRANI, DIPL_LEGITIMACIJA, BRLK_MKD, BRLK_MNE, BRLK_BIH, BRLK_ALB, TIN};
    }
}

