/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.model.view;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import rs.tetrabyte.pos.model.entity.Payment;
import rs.tetrabyte.pos.model.entity.PaymentType;
import rs.tetrabyte.pos.model.view.CustomerView;
import rs.tetrabyte.pos.model.view.InvoiceItemView;
import rs.tetrabyte.pos.sdc.InvoiceTransaction;

public class InvoiceView {
    private UUID id;
    private ObjectProperty<LocalDateTime> dateAndTimeOfIssue = new SimpleObjectProperty();
    private ObjectProperty<InvoiceTransaction> type = new SimpleObjectProperty((Object)InvoiceTransaction.NORMAL_SALE);
    private ListProperty<Payment> payment = new SimpleListProperty();
    private StringProperty cashier = new SimpleStringProperty();
    private StringProperty buyerId = new SimpleStringProperty();
    private StringProperty buyerCostCenterId = new SimpleStringProperty();
    private StringProperty discount = new SimpleStringProperty();
    private StringProperty invoiceNumber = new SimpleStringProperty();
    private StringProperty referentDocumentNumber = new SimpleStringProperty();
    private ObjectProperty<LocalDateTime> referentDocumentDT = new SimpleObjectProperty();
    private ListProperty<InvoiceItemView> items = new SimpleListProperty();
    private StringProperty total = new SimpleStringProperty("");
    private StringProperty uid = new SimpleStringProperty("");
    private ObjectProperty<LocalDateTime> sdcDateTime = new SimpleObjectProperty();
    private StringProperty sdcNumber = new SimpleStringProperty("");
    private ObjectProperty<CustomerView> customer = new SimpleObjectProperty();
    private StringProperty message = new SimpleStringProperty();

    public String getUid() {
        return (String)this.uid.get();
    }

    public StringProperty uidProperty() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid.set((Object)uid);
    }

    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public LocalDateTime getDateAndTimeOfIssue() {
        return (LocalDateTime)this.dateAndTimeOfIssue.get();
    }

    public ObjectProperty<LocalDateTime> dateAndTimeOfIssueProperty() {
        return this.dateAndTimeOfIssue;
    }

    public void setDateAndTimeOfIssue(LocalDateTime dateAndTimeOfIssue) {
        this.dateAndTimeOfIssue.set((Object)dateAndTimeOfIssue);
    }

    public final ObjectProperty<InvoiceTransaction> typeProperty() {
        return this.type;
    }

    public final InvoiceTransaction getType() {
        return (InvoiceTransaction)this.typeProperty().get();
    }

    public final void setType(InvoiceTransaction type) {
        this.typeProperty().set((Object)type);
    }

    public List<Payment> getPayment() {
        return (List)this.payment.get();
    }

    public ListProperty<Payment> paymentProperty() {
        return this.payment;
    }

    public void setPayment(List<Payment> payment) {
        this.payment.set((Object)FXCollections.observableArrayList(payment));
    }

    public String getCashier() {
        return (String)this.cashier.get();
    }

    public StringProperty cashierProperty() {
        return this.cashier;
    }

    public void setCashier(String cashier) {
        this.cashier.set((Object)cashier);
    }

    public String getBuyerId() {
        return (String)this.buyerId.get();
    }

    public StringProperty buyerIdProperty() {
        return this.buyerId;
    }

    public void setBuyerId(String buyerId) {
        this.buyerId.set((Object)buyerId);
    }

    public String getBuyerCostCenterId() {
        return (String)this.buyerCostCenterId.get();
    }

    public StringProperty buyerCostCenterIdProperty() {
        return this.buyerCostCenterId;
    }

    public void setBuyerCostCenterId(String buyerCostCenterId) {
        this.buyerCostCenterId.set((Object)buyerCostCenterId);
    }

    public String getInvoiceNumber() {
        return (String)this.invoiceNumber.get();
    }

    public StringProperty invoiceNumberProperty() {
        return this.invoiceNumber;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber.set((Object)invoiceNumber);
    }

    public String getReferentDocumentNumber() {
        return (String)this.referentDocumentNumber.get();
    }

    public StringProperty referentDocumentNumberProperty() {
        return this.referentDocumentNumber;
    }

    public void setReferentDocumentNumber(String referentDocumentNumber) {
        this.referentDocumentNumber.set((Object)referentDocumentNumber);
    }

    public LocalDateTime getReferentDocumentDT() {
        return (LocalDateTime)this.referentDocumentDT.get();
    }

    public ObjectProperty<LocalDateTime> referentDocumentDTProperty() {
        return this.referentDocumentDT;
    }

    public void setReferentDocumentDT(LocalDateTime referentDocumentDT) {
        this.referentDocumentDT.set((Object)referentDocumentDT);
    }

    public List<InvoiceItemView> getItems() {
        return (List)this.items.get();
    }

    public ListProperty<InvoiceItemView> itemsProperty() {
        return this.items;
    }

    public void setItems(List<InvoiceItemView> items) {
        if (items == null) {
            return;
        }
        this.items.set((Object)FXCollections.observableArrayList(items));
    }

    public String getTotal() {
        return (String)this.total.get();
    }

    public StringProperty totalProperty() {
        return this.total;
    }

    public void setTotal(String total) {
        this.total.set((Object)total);
    }

    public LocalDateTime getSdcDateTime() {
        return (LocalDateTime)this.sdcDateTime.get();
    }

    public ObjectProperty<LocalDateTime> sdcDateTimeProperty() {
        return this.sdcDateTime;
    }

    public void setSdcDateTime(LocalDateTime sdcDateTime) {
        this.sdcDateTime.set((Object)sdcDateTime);
    }

    public final StringProperty sdcNumberProperty() {
        return this.sdcNumber;
    }

    public final String getSdcNumber() {
        return (String)this.sdcNumberProperty().get();
    }

    public final void setSdcNumber(String sdcNumber) {
        this.sdcNumberProperty().set((Object)sdcNumber);
    }

    public final ObjectProperty<CustomerView> customerProperty() {
        return this.customer;
    }

    public final CustomerView getCustomer() {
        return (CustomerView)this.customerProperty().get();
    }

    public final void setCustomer(CustomerView customer) {
        this.customerProperty().set((Object)customer);
    }

    public String getDiscount() {
        return (String)this.discount.get();
    }

    public StringProperty discountProperty() {
        return this.discount;
    }

    public void setDiscount(String discount) {
        this.discount.set((Object)discount);
    }

    public void addPayment(PaymentType type, BigDecimal amount) {
        if (this.payment.getValue() == null) {
            this.payment.set((Object)FXCollections.observableList(new ArrayList()));
        }
        Payment payment = new Payment();
        payment.setPaymentType(type);
        payment.setAmount(amount.setScale(2, RoundingMode.HALF_UP));
        this.payment.add((Object)payment);
    }

    public void addNonZeroPayment(PaymentType type, BigDecimal amount) {
        if (amount == null || amount.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        this.addPayment(type, amount);
    }

    public final StringProperty messageProperty() {
        return this.message;
    }

    public final String getMessage() {
        return (String)this.messageProperty().get();
    }

    public final void setMessage(String message) {
        this.messageProperty().set((Object)message);
    }
}

