/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.factory;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.function.UnaryOperator;
import javafx.scene.control.TextFormatter;
import javafx.util.StringConverter;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;
import rs.tetrabyte.pos.util.Formatter;

@Component
public class FormatterFactory {
    private DecimalFormat priceFormat;
    private DecimalFormat qtyViewFormat;
    private DecimalFormat qtyFieldFormat;
    private DecimalFormat amountFormat;
    private DateTimeFormatter dateTimeFormat;
    private DateFormat dateFormat;
    private int rowLength;

    @PostConstruct
    private void postConstruct() {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(new Locale("sr", "RS"));
        this.priceFormat = new DecimalFormat("###,###.00", symbols);
        this.priceFormat.setParseBigDecimal(true);
        this.priceFormat.setRoundingMode(RoundingMode.HALF_UP);
        this.qtyViewFormat = new DecimalFormat("#", symbols);
        this.qtyViewFormat.setRoundingMode(RoundingMode.HALF_UP);
        this.qtyViewFormat.setMaximumFractionDigits(3);
        this.qtyViewFormat.setParseBigDecimal(true);
        this.qtyFieldFormat = new DecimalFormat("###,###.000", symbols);
        this.qtyFieldFormat.setRoundingMode(RoundingMode.HALF_UP);
        this.qtyFieldFormat.setParseBigDecimal(true);
        this.amountFormat = new DecimalFormat("###,###.00", symbols);
        this.amountFormat.setParseBigDecimal(true);
        this.amountFormat.setRoundingMode(RoundingMode.HALF_UP);
        this.dateTimeFormat = DateTimeFormatter.ofPattern("dd.MM.yyyy. HH:mm:ss");
        this.dateFormat = new SimpleDateFormat("dd.MM.yyyy");
        this.rowLength = 40;
    }

    public Formatter createFormatter(int rowLength) {
        return new Formatter(rowLength, this.priceFormat, this.qtyViewFormat, this.priceFormat, this.dateTimeFormat);
    }

    public Formatter createFormatter() {
        return this.createFormatter(this.rowLength);
    }

    public TextFormatter<BigDecimal> getDecimalTextFormatter(final DecimalFormat decimalFormat) {
        UnaryOperator filter = change -> {
            String oldText = change.getControlText();
            String newText = change.getControlNewText();
            String text = change.getText();
            if (oldText.equals(newText)) {
                return change;
            }
            int originalCaretPosition = change.getCaretPosition();
            try {
                String formattedText;
                BigDecimal parsedNumber = (BigDecimal)decimalFormat.parse(newText);
                String finalText = formattedText = decimalFormat.format(parsedNumber);
                int newCaretPostion = 0;
                if (originalCaretPosition == 1 && text.length() == 1) {
                    newCaretPostion = 1;
                } else if (formattedText.length() == oldText.length()) {
                    newCaretPostion = originalCaretPosition >= formattedText.length() ? formattedText.length() : originalCaretPosition;
                } else if (formattedText.length() > oldText.length()) {
                    if (change.isDeleted()) {
                        char decimalSeparator = decimalFormat.getDecimalFormatSymbols().getDecimalSeparator();
                        if (oldText.charAt(originalCaretPosition) == decimalSeparator) {
                            finalText = oldText;
                            newCaretPostion = originalCaretPosition;
                        }
                    } else {
                        newCaretPostion = originalCaretPosition + formattedText.length() - oldText.length() - 1;
                    }
                } else {
                    newCaretPostion = originalCaretPosition - (oldText.length() - formattedText.length()) + 1;
                }
                newCaretPostion = newCaretPostion >= 0 ? newCaretPostion : 0;
                change.setText(finalText);
                change.setRange(0, change.getControlText().length());
                change.setAnchor(newCaretPostion);
                change.setCaretPosition(newCaretPostion);
                return change;
            }
            catch (ParseException e) {
                return null;
            }
        };
        StringConverter<BigDecimal> converter = new StringConverter<BigDecimal>(){

            public String toString(BigDecimal object) {
                return decimalFormat.format(object);
            }

            public BigDecimal fromString(String string) {
                try {
                    return (BigDecimal)decimalFormat.parse(string);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        };
        return new TextFormatter((StringConverter)converter, (Object)BigDecimal.ZERO, filter);
    }

    public TextFormatter<BigDecimal> getPriceTextFormatter() {
        return this.getDecimalTextFormatter(this.priceFormat);
    }

    public TextFormatter<BigDecimal> getQtyTextFormatter() {
        return this.getDecimalTextFormatter(this.qtyFieldFormat);
    }

    public TextFormatter<BigDecimal> getAmountTextFormatter() {
        return this.getDecimalTextFormatter(this.amountFormat);
    }

    public DecimalFormat getPriceFormat() {
        return this.priceFormat;
    }

    public DecimalFormat getQtyViewFormat() {
        return this.qtyViewFormat;
    }

    public DecimalFormat getAmountFormat() {
        return this.amountFormat;
    }

    public DateTimeFormatter getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }
}

