/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.dao;

import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import rs.tetrabyte.pos.model.entity.VatType;
import rs.tetrabyte.pos.model.entity.VatTypeMap;
import rs.tetrabyte.pos.repository.VatTypeMapRepository;

@Component
public class VatTypeMapDAO {
    @Autowired
    private VatTypeMapRepository repo;

    @PostConstruct
    private void generateFakeData() {
        if (this.repo.count() == 0L) {
            this.repo.save(new VatTypeMap(VatType.GENERAL, "\u0416"));
            this.repo.save(new VatTypeMap(VatType.SPECIAL, "A"));
            this.repo.save(new VatTypeMap(VatType.NONE, "B"));
        }
    }

    public String getLabelForVatType(VatType vatType) {
        return this.repo.findById((Object)vatType).map(VatTypeMap::getLabel).orElseThrow(() -> new IllegalArgumentException("Type configuration missing for vat type " + vatType.name()));
    }

    public VatTypeMap save(VatTypeMap value) {
        return (VatTypeMap)this.repo.save(value);
    }

    public void saveAll(List<VatTypeMap> list) {
        this.repo.saveAll(list);
    }

    public List<VatTypeMap> findAll() {
        return this.repo.findAll();
    }
}

