/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.dao;

import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import rs.tetrabyte.pos.dao.FakeDAO;
import rs.tetrabyte.pos.dao.ItemDAO;
import rs.tetrabyte.pos.model.entity.InvoiceItem;
import rs.tetrabyte.pos.model.entity.Item;
import rs.tetrabyte.pos.repository.InvoiceItemRepository;

@Component
public class InvoiceItemDAO
extends FakeDAO {
    @Autowired
    private ItemDAO itemDao;
    @Autowired
    private InvoiceItemRepository invoiceItemRepo;
    private List<InvoiceItem> invoiceItems;

    @PostConstruct
    void generateFakeData() {
        this.invoiceItems = this.generate(10, () -> {
            Item item = this.getRandomItem();
            InvoiceItem invoiceItem = new InvoiceItem();
            invoiceItem.setId(UUID.randomUUID());
            invoiceItem.setItemId(item.getId());
            invoiceItem.setItemType(item.getItemType());
            invoiceItem.setVatType(item.getVatType());
            invoiceItem.setUid(item.getUid());
            invoiceItem.setEan(item.getEan());
            invoiceItem.setUnit(item.getUnit());
            invoiceItem.setShortName(item.getShortName() + "/" + item.getUnit());
            invoiceItem.setLongName(item.getLongName());
            invoiceItem.setPrice(item.getPrice());
            invoiceItem.setQuantity(new BigDecimal(this.faker().random().nextInt(1, 12)));
            invoiceItem.setTotal(invoiceItem.getQuantity().multiply(invoiceItem.getPrice()));
            return invoiceItem;
        });
    }

    private Item getRandomItem() {
        List<Item> items = this.itemDao.getAllItems();
        int random = this.faker().random().nextInt(0, items.size() - 1);
        return items.get(random);
    }

    public List<InvoiceItem> getInvoiceItems() {
        return this.invoiceItems;
    }

    public InvoiceItem addItemToInvoice(Item item, BigDecimal price, BigDecimal quantity) {
        InvoiceItem invoiceItem = new InvoiceItem();
        invoiceItem.setId(UUID.randomUUID());
        invoiceItem.setItemId(item.getId());
        invoiceItem.setItemType(item.getItemType());
        invoiceItem.setVatType(item.getVatType());
        invoiceItem.setUnit(item.getUnit());
        invoiceItem.setUid(item.getUid());
        invoiceItem.setEan(item.getEan());
        invoiceItem.setShortName(item.getShortName() + "/" + item.getUnit());
        invoiceItem.setLongName(item.getLongName());
        invoiceItem.setPrice(price != null ? price : item.getPrice());
        invoiceItem.setQuantity(quantity);
        invoiceItem.setTotal(invoiceItem.getQuantity().multiply(invoiceItem.getPrice()));
        this.invoiceItems.add(invoiceItem);
        return invoiceItem;
    }

    public InvoiceItem addInvoiceItem(InvoiceItem invoiceItem) {
        if (invoiceItem.getId() == null) {
            invoiceItem.setId(UUID.randomUUID());
        }
        this.invoiceItems.add(invoiceItem);
        return invoiceItem;
    }

    public InvoiceItem updateInvoiceItem(InvoiceItem updatedItem) {
        for (InvoiceItem invoiceItem : this.invoiceItems) {
            if (!invoiceItem.getId().equals(updatedItem.getId())) continue;
            invoiceItem.setPrice(updatedItem.getPrice());
            invoiceItem.setQuantity(updatedItem.getQuantity());
            invoiceItem.setTotal(updatedItem.getTotal());
            return invoiceItem;
        }
        throw new IllegalArgumentException("Invoice item with id " + String.valueOf(updatedItem.getId()) + " not found.");
    }

    public void incInvoiceItemQuantity(UUID id, BigDecimal price, BigDecimal quantity) {
        this.invoiceItems.stream().filter(i -> i.getItemId().equals(id) && i.getPrice().equals(price)).findFirst().ifPresentOrElse(i -> {
            i.setQuantity(i.getQuantity().add(quantity));
            i.setTotal(i.getQuantity().multiply(i.getPrice()));
        }, () -> {
            throw new IllegalArgumentException("Item with id " + String.valueOf(id) + " could not be found in current invoice");
        });
    }

    public Optional<InvoiceItem> removeInvoiceItem(UUID id) {
        Optional<InvoiceItem> optional = this.invoiceItems.stream().filter(i -> i.getId().equals(id)).findAny();
        if (optional.isPresent()) {
            this.invoiceItems.remove(optional.get());
            return optional;
        }
        return Optional.empty();
    }

    public void removeAllInvoiceItems() {
        this.invoiceItems.clear();
    }

    public void saveInvoiceItems(List<InvoiceItem> invoiceItems) {
        this.invoiceItemRepo.saveAll(invoiceItems);
    }

    public List<InvoiceItem> findByInvoiceId(UUID uuid) {
        return this.invoiceItemRepo.findByInvoiceId(uuid);
    }
}

