/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.dao;

import com.github.javafaker.Faker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import org.apache.commons.lang3.LocaleUtils;
import org.controlsfx.glyphfont.FontAwesome;

public abstract class FakeDAO {
    private Faker faker = Faker.instance((Locale)LocaleUtils.toLocale((String)"sr_RS"));

    protected BigDecimal decimal(String number) {
        return new BigDecimal(number.replace(',', '.'));
    }

    protected <T> List<T> generate(int count, Supplier<T> s) {
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < count; ++i) {
            list.add(s.get());
        }
        return list;
    }

    protected Faker faker() {
        return this.faker;
    }

    protected String randomGlyphCode() {
        FontAwesome.Glyph[] values = FontAwesome.Glyph.values();
        int random = this.faker().random().nextInt(1, values.length - 1);
        char chr = values[random].getChar();
        String hex = String.format("%04x", chr);
        return "default:" + hex;
    }

    protected void sleep(int milis) {
        try {
            Thread.sleep(milis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

