/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.dao;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import rs.tetrabyte.pos.dao.FakeDAO;
import rs.tetrabyte.pos.dao.Page;
import rs.tetrabyte.pos.model.entity.Customer;
import rs.tetrabyte.pos.model.entity.CustomerType;
import rs.tetrabyte.pos.repository.CustomerRepository;
import rs.tetrabyte.pos.util.Specs;
import rs.tetrabyte.pos.util.StringUtil;

@Component
public class CustomerDAO
extends FakeDAO {
    @Autowired
    private CustomerRepository customerRepo;

    @PostConstruct
    void generateFakeData() {
        if (this.customerRepo.count() != 0L) {
            return;
        }
        List<Customer> customers = this.generate(1000, () -> {
            Customer c = new Customer();
            c.setId(UUID.randomUUID());
            c.setUid(this.faker().number().digits(8));
            c.setName(this.faker().company().name());
            c.setAddress(this.faker().address().streetAddress());
            c.setPostalCode(this.faker().address().zipCode());
            c.setCity(this.faker().address().city());
            c.setNationalId(this.faker().number().digits(8));
            c.setTin(this.faker().number().digits(9));
            c.setUpfun(this.faker().number().digits(5));
            c.setEmail(this.faker().internet().emailAddress());
            c.setType((CustomerType)this.faker().options().option(CustomerType.class));
            c.setKeywords(this.getKeywords(c));
            return c;
        });
        this.customerRepo.saveAll(customers);
    }

    private String getKeywords(Customer c) {
        if (c == null) {
            return "";
        }
        return StringUtil.toKeywords(c.getUid(), c.getName().toLowerCase(), c.getTin(), c.getCity(), c.getAddress(), c.getEmail(), c.getNationalId(), c.getPostalCode());
    }

    public long getCustomerCount() {
        return this.customerRepo.count();
    }

    public void addCustomer(Customer customer) {
        if (customer == null || customer.getUid() == null || customer.getUid().isEmpty()) {
            throw new IllegalArgumentException("Customer or UID must not be null or empty");
        }
        if (customer.getId() == null) {
            Optional<Customer> existingCustomer = this.customerRepo.findByUid(customer.getUid());
            if (existingCustomer.isPresent()) {
                throw new IllegalArgumentException("Customer with the same UID already exists");
            }
            customer.setId(UUID.randomUUID());
        }
        customer.setKeywords(this.getKeywords(customer));
        this.customerRepo.save(customer);
    }

    public void updateCustomer(Customer customer) {
        if (customer == null || customer.getUid() == null || customer.getUid().isEmpty()) {
            throw new IllegalArgumentException("Customer or UID must not be null or empty");
        }
        Optional existingCustomer = this.customerRepo.findById(customer.getId());
        if (!existingCustomer.isPresent()) {
            throw new IllegalArgumentException("Customer with given UID not found");
        }
        Customer c = (Customer)existingCustomer.get();
        c.setName(customer.getName());
        c.setAddress(customer.getAddress());
        c.setPostalCode(customer.getPostalCode());
        c.setCity(customer.getCity());
        c.setNationalId(customer.getNationalId());
        c.setTin(customer.getTin());
        c.setUpfun(customer.getUpfun());
        c.setEmail(customer.getEmail());
        c.setType(customer.getType());
        c.setKeywords(this.getKeywords(c));
    }

    public Page<Customer> getAllCustomers(int pageSize, int pageNumber) {
        return Page.of(this.customerRepo.findAll((Pageable)PageRequest.of((int)pageNumber, (int)pageSize)));
    }

    public Optional<Customer> findCustomerByUid(String uid) {
        return this.customerRepo.findByUid(uid);
    }

    public Page<Customer> searchCustomers(String string, int pageSize, int pageNumber) {
        if (string == null || string.isEmpty()) {
            return Page.empty();
        }
        return Page.of(this.customerRepo.findAll(Specs.containsKeyword(string), (Pageable)PageRequest.of((int)pageNumber, (int)pageSize)));
    }

    public Optional<Customer> removeCustomer(String uid) {
        Optional<Customer> customer = this.findCustomerByUid(uid);
        customer.ifPresent(arg_0 -> ((CustomerRepository)this.customerRepo).delete(arg_0));
        return customer;
    }
}

