/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.controller.factory;

import java.text.DecimalFormat;
import java.time.format.DateTimeFormatter;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.util.Callback;
import org.springframework.stereotype.Component;
import rs.tetrabyte.pos.factory.FormatterFactory;
import rs.tetrabyte.pos.model.view.DailyReportView;

@Component
public class DailyReportListCellFactory
implements Callback<ListView<DailyReportView>, ListCell<DailyReportView>> {
    private DecimalFormat amountFormat;
    private DateTimeFormatter dateTimeFormat;

    public DailyReportListCellFactory(FormatterFactory formatterFactory) {
        this.amountFormat = formatterFactory.getAmountFormat();
        this.dateTimeFormat = formatterFactory.getDateTimeFormat();
    }

    public ListCell<DailyReportView> call(ListView<DailyReportView> itemTypeListView) {
        return new ListCell<DailyReportView>(){

            protected void updateItem(DailyReportView report, boolean empty) {
                super.updateItem((Object)report, empty);
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                if (empty || report == null) {
                    this.setText(null);
                    this.setGraphic(null);
                } else {
                    Text dateTime = new Text(String.format("(%s)", DailyReportListCellFactory.this.dateTimeFormat.format(report.getDateTime())));
                    dateTime.getStyleClass().add((Object)"heading4");
                    Text number = new Text(report.getUid() + "-" + String.format("%05d", report.getNumber()));
                    number.getStyleClass().add((Object)"heading4");
                    Text total = new Text(DailyReportListCellFactory.this.amountFormat.format(report.getTotal()));
                    total.getStyleClass().add((Object)"heading4");
                    HBox totalBox = new HBox(new Node[]{total});
                    HBox.setHgrow((Node)totalBox, (Priority)Priority.ALWAYS);
                    totalBox.setAlignment(Pos.CENTER_RIGHT);
                    HBox firstRow = new HBox(5.0, new Node[]{number, dateTime});
                    HBox secondRow = new HBox(new Node[]{totalBox});
                    VBox content = new VBox(new Node[]{firstRow, secondRow});
                    content.setPadding(new Insets(5.0));
                    this.setGraphic((Node)content);
                }
            }
        };
    }
}

