/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.controller.factory;

import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.util.Callback;
import rs.tetrabyte.pos.model.entity.CustomerType;

public class CustomerTypeCellFactory
implements Callback<ListView<CustomerType>, ListCell<CustomerType>> {
    public ListCell<CustomerType> call(ListView<CustomerType> param) {
        return new ListCell<CustomerType>(){

            protected void updateItem(CustomerType type, boolean empty) {
                super.updateItem((Object)type, empty);
                if (empty || type == null) {
                    this.setText(null);
                } else {
                    this.setText(this.formatCustomerType(type));
                }
            }

            private String formatCustomerType(CustomerType customerType) {
                switch (customerType) {
                    case LEGAL_PERSON: {
                        return "PRAVNO LICE";
                    }
                    case INDIVIDUAL_PERSON: {
                        return "FIZI\u010cKO LICE";
                    }
                }
                return "";
            }
        };
    }
}

