/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.controller.factory;

import java.util.function.Consumer;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.util.Callback;
import org.controlsfx.control.GridCell;
import org.controlsfx.control.GridView;
import rs.tetrabyte.pos.model.view.CategoryView;
import rs.tetrabyte.xcelerate.app.factory.GlyphFactory;
import rs.tetrabyte.xcelerate.app.util.StringUtils;

public class CategoryGridCellFactory
implements Callback<GridView<CategoryView>, GridCell<CategoryView>> {
    private Consumer<CategoryView> consumer;

    public CategoryGridCellFactory(Consumer<CategoryView> consumer) {
        this.consumer = consumer;
    }

    public GridCell<CategoryView> call(GridView<CategoryView> param) {
        return new GridCell<CategoryView>(){

            protected void updateItem(CategoryView item, boolean empty) {
                super.updateItem((Object)item, empty);
                this.setFocusTraversable(false);
                if (empty || item == null) {
                    this.setText(null);
                    this.setGraphic(null);
                } else {
                    this.setText(null);
                    Button btn = new Button(item.getName());
                    btn.setFocusTraversable(false);
                    btn.setContentDisplay(ContentDisplay.RIGHT);
                    if (!StringUtils.isEmpty(item.getIconCode())) {
                        btn.setGraphic((Node)GlyphFactory.createGlyph(item.getIconCode()));
                    }
                    btn.setOnAction(e -> CategoryGridCellFactory.this.consumer.accept(item));
                    btn.setWrapText(true);
                    btn.setAlignment(Pos.BASELINE_LEFT);
                    this.setGraphic((Node)btn);
                }
            }
        };
    }
}

