/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.pos.model.entity.VatType;
import rs.tetrabyte.pos.model.view.VatTypeMapView;
import rs.tetrabyte.pos.sdc.model.TaxGroup;
import rs.tetrabyte.pos.service.SDCService;
import rs.tetrabyte.pos.service.VatTypeMapService;
import rs.tetrabyte.xcelerate.app.commands.UICommands;
import rs.tetrabyte.xcelerate.app.control.LockablePaneWrapper;
import rs.tetrabyte.xcelerate.core.fxml.FXMLController;
import rs.tetrabyte.xcelerate.core.fxml.annotation.FXMLView;

@FXMLView(value="/fxml/VatTypeMapView.fxml", wrappers={LockablePaneWrapper.class})
public class VatTypeMapViewController
extends FXMLController {
    @FXML
    private VBox content;
    @FXML
    private Label message;
    @Autowired
    private VatTypeMapService service;
    @Autowired
    private SDCService sdcService;
    @Autowired
    private UICommands commands;
    private List<VatTypeMapView> data = new ArrayList<VatTypeMapView>();

    @PostConstruct
    private void initData() {
        this.doAsync(() -> this.sdcService.getTaxRates()).whenDone(rates -> {
            for (int i = 0; i < VatType.values().length; ++i) {
                VatType type = VatType.values()[i];
                VatTypeMapView view = new VatTypeMapView();
                this.data.add(view);
                view.setVatType(type);
                HBox hBox = new HBox(10.0);
                hBox.setAlignment(Pos.CENTER);
                Label lbl = new Label(type.getDesc());
                lbl.getStyleClass().add((Object)"heading3");
                lbl.setPrefWidth(100.0);
                hBox.getChildren().addAll((Object[])new Node[]{lbl, new Label("=")});
                ComboBox cbLabel = new ComboBox();
                cbLabel.setPrefWidth(200.0);
                cbLabel.getItems().addAll((Collection)rates);
                cbLabel.setConverter((StringConverter)new StringConverter<TaxGroup.TaxCategory.TaxRate>(){

                    public String toString(TaxGroup.TaxCategory.TaxRate rate) {
                        return rate != null ? String.format("%s (%s %%)", rate.getLabel(), rate.getRate().toString()) : null;
                    }

                    public TaxGroup.TaxCategory.TaxRate fromString(String string) {
                        return null;
                    }
                });
                hBox.getChildren().add((Object)cbLabel);
                this.content.getChildren().add((Object)hBox);
                cbLabel.getSelectionModel().selectedItemProperty().addListener((o, ov, nv) -> view.setLabel(nv.getLabel()));
                view.labelProperty().addListener((o, ov, nv) -> cbLabel.getSelectionModel().select((Object)rates.stream().filter(r -> r.getLabel().equals(nv)).findFirst().get()));
            }
            this.doAsync(() -> this.service.findAll()).whenDone(list -> list.forEach(e -> this.data.stream().filter(a -> a.getVatType() == e.getVatType()).findAny().ifPresent(a -> a.setLabel(e.getLabel()))));
        });
    }

    @FXML
    public void save() {
        if (this.data.size() == 0) {
            return;
        }
        this.data.stream().filter(value -> value.getLabel() == null).findAny().ifPresentOrElse(a -> this.message.setText("Poreske stope nisu ispravno konfigurisane.\r\nDovr\u0161ite konfiguraciju za nastavak rada."), () -> this.doAsync(() -> {
            this.service.saveAll(this.data);
            return null;
        }).whenDone(a -> this.commands.removeView((Node)this.getRootNode()).execute()));
    }

    @FXML
    public void cancel() {
        this.commands.removeView((Node)this.getRootNode()).execute();
    }
}

