/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.controller;

import java.util.Collection;
import java.util.function.Consumer;
import javafx.beans.property.ObjectProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javax.annotation.PostConstruct;
import org.controlsfx.control.GridView;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.pos.controller.KeyboardController;
import rs.tetrabyte.pos.controller.factory.CategoryGridCellFactory;
import rs.tetrabyte.pos.controller.factory.ItemCellFactory;
import rs.tetrabyte.pos.model.view.CategoryView;
import rs.tetrabyte.pos.model.view.InvoiceItemView;
import rs.tetrabyte.pos.model.view.ItemView;
import rs.tetrabyte.pos.service.CategoryService;
import rs.tetrabyte.pos.service.InvoiceItemService;
import rs.tetrabyte.pos.service.ItemService;
import rs.tetrabyte.pos.service.KeyboardService;
import rs.tetrabyte.xcelerate.app.control.LockablePaneWrapper;
import rs.tetrabyte.xcelerate.app.factory.GlyphFactory;
import rs.tetrabyte.xcelerate.app.util.StringUtils;
import rs.tetrabyte.xcelerate.core.fxml.FXMLController;
import rs.tetrabyte.xcelerate.core.fxml.annotation.FXMLView;
import rs.tetrabyte.xcelerate.core.fxml.annotation.Input;
import rs.tetrabyte.xcelerate.core.fxml.annotation.Output;
import rs.tetrabyte.xcelerate.core.task.AbstractTask;
import rs.tetrabyte.xcelerate.core.task.TaskFactory;
import rs.tetrabyte.xcelerate.core.task.UIAccessor;

@FXMLView(value="/fxml/SearchView.fxml", wrappers={LockablePaneWrapper.class})
public class SearchViewController
extends FXMLController {
    private static final int ITEM_PAGE_SIZE = 30;
    @FXML
    @Output
    private TextField txtSearch;
    @FXML
    private TabPane viewCategories;
    @FXML
    private GridView<ItemView> viewItems;
    @FXML
    private VBox rootVBox;
    @FXML
    private FlowPane pagination;
    private Node keyboardView;
    @Autowired
    private CategoryService categoryService;
    @Autowired
    private ItemService itemService;
    @Autowired
    private InvoiceItemService invoiceItemService;
    @Autowired
    private TaskFactory taskFactory;
    private boolean isKeyboardActive = false;
    @Input
    private ObjectProperty<ObservableList<InvoiceItemView>> invoiceItems;
    @Autowired
    KeyboardService keyboardService;

    @PostConstruct
    void postConstruct() {
        this.viewCategories.setFocusTraversable(false);
        this.viewItems.setFocusTraversable(false);
        this.viewItems.setCellFactory((Callback)new ItemCellFactory(item -> this.invoiceItemService.addItemToInvoiceAsync((ItemView)item)));
        this.taskFactory.createTask(() -> this.categoryService.getRootCategories()).execute(roots -> {
            roots.forEach(cat -> {
                Tab tab = new Tab(cat.getName());
                if (!StringUtils.isEmpty(cat.getIconCode())) {
                    tab.setGraphic((Node)GlyphFactory.createGlyph(cat.getIconCode()));
                }
                tab.setOnSelectionChanged(e -> {
                    GridView childrenGrid = new GridView();
                    childrenGrid.setFocusTraversable(false);
                    childrenGrid.getStyleClass().add((Object)"grid-view-categories");
                    childrenGrid.setCellFactory((Callback)new CategoryGridCellFactory(child -> this.taskFactory.createTask(() -> this.categoryService.getChildrenCategories((CategoryView)child)).execute(cats -> {
                        if (cats.size() == 0) {
                            this.updateItems((CategoryView)child);
                        }
                    })));
                    childrenGrid.setPadding(new Insets(5.0, 0.0, 5.0, 0.0));
                    this.taskFactory.createTask(() -> this.categoryService.getChildrenCategories((CategoryView)cat)).execute(children -> {
                        childrenGrid.getItems().addAll((Collection)children);
                        tab.setContent((Node)childrenGrid);
                        if (children.size() > 0) {
                            this.updateItems((CategoryView)children.get(0));
                        }
                    });
                });
                this.viewCategories.getTabs().add((Object)tab);
            });
            if (this.viewCategories.getTabs().size() > 0) {
                this.viewCategories.getSelectionModel().select(0);
            }
        });
        this.txtSearch.setOnKeyPressed(e -> {
            if (e.getCode() == KeyCode.ENTER) {
                ((AbstractTask)((Object)((Object)this.taskFactory.createTask(() -> this.itemService.searchItems(this.txtSearch.getText(), 30, 0)).uiAccessor((UIAccessor)this.getRootNode())))).execute(page -> {
                    this.viewItems.getItems().setAll(page.getData());
                    this.updatePagination(page.getPageCount(), pageNumber -> ((AbstractTask)((Object)((Object)((Object)((Object)this.taskFactory.createTask(() -> this.itemService.searchItems(this.txtSearch.getText(), 30, (int)pageNumber)).uiAccessor((UIAccessor)this.getRootNode())))))).execute(page1 -> this.viewItems.getItems().setAll(page1.getData())));
                });
            }
        });
    }

    private void updateItems(CategoryView category) {
        ((AbstractTask)((Object)this.taskFactory.createTask(() -> this.itemService.getItemsByCategory(category, 30, 0)).uiAccessor((UIAccessor)this.getRootNode()))).execute(page -> {
            this.viewItems.getItems().setAll(page.getData());
            this.updatePagination(page.getPageCount(), pageNumber -> ((AbstractTask)((Object)((Object)((Object)this.taskFactory.createTask(() -> this.itemService.getItemsByCategory(category, 30, (int)pageNumber)).uiAccessor((UIAccessor)this.getRootNode()))))).execute(page1 -> this.viewItems.getItems().setAll(page1.getData())));
        });
    }

    private void updatePagination(int pageCount, Consumer<Integer> param) {
        this.pagination.getChildren().clear();
        if (pageCount == 1) {
            return;
        }
        for (int i = 0; i < pageCount; ++i) {
            Integer pageNumber = i;
            Button btn = new Button(String.valueOf(i + 1));
            btn.setOnAction(e -> param.accept(pageNumber));
            this.pagination.getChildren().add((Object)btn);
        }
    }

    @FXML
    private void onKeyboard(MouseEvent event) {
        if (!this.isKeyboardActive) {
            this.isKeyboardActive = true;
            this.loadView(KeyboardController.class).output("parent", (Object)this).getView(view -> {
                this.keyboardView = view;
                this.rootVBox.getChildren().add(view);
                this.txtSearch.requestFocus();
            });
        }
    }

    public void activateKeyboard(MouseEvent event) {
        this.onKeyboard(event);
    }

    public void removeInvoiceKeyboard() {
        if (this.keyboardView != null) {
            this.rootVBox.getChildren().remove((Object)this.keyboardView);
            this.keyboardView = null;
            this.isKeyboardActive = false;
        }
    }

    public void removeKeyboard() {
        this.removeInvoiceKeyboard();
    }
}

