/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.controller;

import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.pos.controller.CategoryController;
import rs.tetrabyte.pos.controller.CustomersViewController;
import rs.tetrabyte.pos.controller.InvoiceListController;
import rs.tetrabyte.pos.controller.InvoiceViewController;
import rs.tetrabyte.pos.controller.ItemController;
import rs.tetrabyte.pos.controller.SearchViewController;
import rs.tetrabyte.pos.controller.VatTypeMapViewController;
import rs.tetrabyte.pos.service.KeyboardService;
import rs.tetrabyte.pos.service.VatTypeMapService;
import rs.tetrabyte.xcelerate.app.action.Action;
import rs.tetrabyte.xcelerate.app.commands.UICommands;
import rs.tetrabyte.xcelerate.app.context.AcceleratorService;
import rs.tetrabyte.xcelerate.app.control.LockablePaneWrapper;
import rs.tetrabyte.xcelerate.core.fxml.FXMLController;
import rs.tetrabyte.xcelerate.core.fxml.annotation.FXMLView;

@FXMLView(value="/fxml/PosView.fxml", wrappers={LockablePaneWrapper.class})
public class PosViewController
extends FXMLController {
    @Autowired
    private AcceleratorService acceleratorService;
    @Autowired
    private KeyboardService keyboardService;
    @FXML
    private BorderPane searchArea;
    @FXML
    private BorderPane navigationArea;
    @FXML
    private BorderPane invoiceArea;
    @Autowired
    private UICommands uiCommands;
    @Autowired
    private VatTypeMapService vatTypeMapService;

    @PostConstruct
    void initView() {
        this.loadView(SearchViewController.class).prepare(view -> {
            this.searchArea.setCenter(view);
            this.keyboardService.setParent((StackPane)view);
        }).loadView(InvoiceViewController.class).prepare(view -> {
            this.invoiceArea.setCenter(view);
            this.acceleratorService.refresh();
            if (!this.vatTypeMapService.isConfigured()) {
                this.loadView(VatTypeMapViewController.class).get(fxml -> this.uiCommands.displayContent(fxml).closable(false).execute());
            }
        }).load();
    }

    @Action(id="action-categories", order=2, text="Kategorije", accelerator="Ctrl+K")
    public void onCategoryShow() {
        this.loadView(CategoryController.class).get(view -> this.uiCommands.displayContent(view).closable(true).execute());
    }

    @Action(id="action-items", order=1, text="Artikli", accelerator="Ctrl+R")
    public void onItemShow(ActionEvent event) {
        this.loadView(ItemController.class).get(view -> this.uiCommands.displayContent(view).closable(true).execute());
    }

    @Action(id="action-customers", order=3, text="Kupci", accelerator="Ctrl+U")
    public void onCustomerShow(ActionEvent event) {
        this.loadView(CustomersViewController.class).get(fxml -> this.uiCommands.displayContent(fxml).closable(true).execute());
    }

    @Action(id="action-invoices", order=0, text="Izdati ra\u010duni", accelerator="Ctrl+I")
    public void onInvoiceShow(ActionEvent event) {
        this.loadView(InvoiceListController.class).get(view -> this.uiCommands.displayContent(view).closable(true).execute());
    }
}

