/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.controller;

import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.pos.controller.CategoryController;
import rs.tetrabyte.pos.controller.CustomersViewController;
import rs.tetrabyte.pos.controller.DailyReportViewController;
import rs.tetrabyte.pos.controller.InvoiceListController;
import rs.tetrabyte.pos.controller.ItemController;
import rs.tetrabyte.pos.controller.PeriodicReportViewController;
import rs.tetrabyte.pos.controller.PosViewController;
import rs.tetrabyte.pos.controller.PreviewReportViewController;
import rs.tetrabyte.pos.controller.VatTypeMapViewController;
import rs.tetrabyte.pos.service.SDCService;
import rs.tetrabyte.xcelerate.app.commands.UICommands;
import rs.tetrabyte.xcelerate.core.fxml.FXMLController;
import rs.tetrabyte.xcelerate.core.fxml.annotation.FXMLView;

@FXMLView(value="/fxml/OptionsView.fxml")
public class OptionsViewController
extends FXMLController {
    @Autowired
    private UICommands uiCommands;
    @Autowired
    SDCService sdcService;

    private void pushView(Class<? extends FXMLController> type, boolean closable) {
        this.loadView(type).get(fxml -> this.uiCommands.displayContent(fxml).closable(closable).execute());
    }

    @FXML
    public void posView(ActionEvent event) {
        this.pushView(PosViewController.class, true);
    }

    @FXML
    public void itemsView(ActionEvent event) {
        this.pushView(ItemController.class, true);
    }

    @FXML
    public void customersView(ActionEvent event) {
        this.pushView(CustomersViewController.class, true);
    }

    @FXML
    public void invoicesView(ActionEvent event) {
        this.pushView(InvoiceListController.class, true);
    }

    @FXML
    public void categoriesView(ActionEvent event) {
        this.pushView(CategoryController.class, true);
    }

    @FXML
    public void previewReport(ActionEvent event) {
        this.doAsync(() -> this.sdcService.attention()).whenDone(code -> this.pushView(PreviewReportViewController.class, false));
    }

    @FXML
    public void dailyReport(ActionEvent event) {
        this.pushView(DailyReportViewController.class, false);
    }

    @FXML
    public void periodicReport(ActionEvent event) {
        this.pushView(PeriodicReportViewController.class, false);
    }

    @FXML
    public void parametersView(ActionEvent event) {
    }

    @FXML
    public void esdcView(ActionEvent event) {
    }

    @FXML
    public void taxRatesView(ActionEvent event) {
        this.doAsync(() -> this.sdcService.attention()).whenDone(code -> this.pushView(VatTypeMapViewController.class, false));
    }
}

