/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.controller;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.ListView;
import javafx.scene.control.Pagination;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.pos.controller.InvoiceCancellationController;
import rs.tetrabyte.pos.dao.Page;
import rs.tetrabyte.pos.model.view.InvoiceItemView;
import rs.tetrabyte.pos.model.view.InvoiceView;
import rs.tetrabyte.pos.sdc.InvoiceTransaction;
import rs.tetrabyte.pos.service.InvoiceService;
import rs.tetrabyte.xcelerate.app.action.Action;
import rs.tetrabyte.xcelerate.app.commands.UICommands;
import rs.tetrabyte.xcelerate.core.fxml.FXMLController;
import rs.tetrabyte.xcelerate.core.fxml.annotation.FXMLView;
import rs.tetrabyte.xcelerate.core.fxml.annotation.Input;
import rs.tetrabyte.xcelerate.core.fxml.annotation.Output;
import rs.tetrabyte.xcelerate.core.fxml.annotation.ScopeType;
import rs.tetrabyte.xcelerate.core.task.TaskFactory;

@FXMLView(value="/fxml/InvoiceListView.fxml")
public class InvoiceListController
extends FXMLController {
    @FXML
    private TableView<InvoiceView> invoiceTable;
    @FXML
    private TextField txtFindName;
    @FXML
    private Pagination pagination;
    @FXML
    private TableColumn<InvoiceView, String> timeColumn;
    @FXML
    private TableColumn<InvoiceView, String> typeColumn;
    @FXML
    private TableColumn<InvoiceView, String> priceColumn;
    @FXML
    private TableColumn<InvoiceView, String> numberColumn;
    @FXML
    private ComboBox<InvoiceTransaction> receiptTypeComboBox;
    @FXML
    private DatePicker startDate;
    @FXML
    private DatePicker endDate;
    @FXML
    private TextField txtSearch;
    @Input
    @FXML
    private ListView<InvoiceItemView> listInvoiceItems;
    @Autowired
    private InvoiceService invoiceService;
    @Autowired
    private TaskFactory taskFactory;
    @Autowired
    private UICommands uiCommands;
    @FXML
    private Button searchByDate;
    @Autowired
    private static final int pageSize = 100;
    @Output(scope=ScopeType.FULL)
    private InvoiceView selectedItem;

    private Page<InvoiceView> getCombinedInvoices(LocalDate start, LocalDate end, int pageSize, int pageIndex) {
        ArrayList<InvoiceView> allInvoices = new ArrayList<InvoiceView>();
        allInvoices.addAll(this.invoiceService.getInvoicesByDateAndType(start, end, InvoiceTransaction.NORMAL_SALE, Integer.MAX_VALUE, 0).getData());
        allInvoices.addAll(this.invoiceService.getInvoicesByDateAndType(start, end, InvoiceTransaction.NORMAL_REFUND, Integer.MAX_VALUE, 0).getData());
        int total = allInvoices.size();
        int fromIndex = pageIndex * pageSize;
        int toIndex = Math.min(fromIndex + pageSize, total);
        List pageData = allInvoices.subList(fromIndex, toIndex);
        int pageCount = (int)Math.ceil((double)total / (double)pageSize);
        return new Page<InvoiceView>(pageSize, pageCount, pageIndex, total, pageData);
    }

    private Page<InvoiceView> getCombinedInvoicesByTypeOnly(int pageSize, int pageIndex) {
        ArrayList<InvoiceView> allInvoices = new ArrayList<InvoiceView>();
        allInvoices.addAll(this.invoiceService.getInvoicesByType(InvoiceTransaction.NORMAL_SALE, Integer.MAX_VALUE, 0).getData());
        allInvoices.addAll(this.invoiceService.getInvoicesByType(InvoiceTransaction.NORMAL_REFUND, Integer.MAX_VALUE, 0).getData());
        int total = allInvoices.size();
        int fromIndex = pageIndex * pageSize;
        int toIndex = Math.min(fromIndex + pageSize, total);
        List pageData = allInvoices.subList(fromIndex, toIndex);
        int pageCount = (int)Math.ceil((double)total / (double)pageSize);
        return new Page<InvoiceView>(pageSize, pageCount, pageIndex, total, pageData);
    }

    public void loadInvoicesByType() {
        InvoiceTransaction selectedType = (InvoiceTransaction)this.receiptTypeComboBox.getValue();
        if (selectedType == null) {
            selectedType = InvoiceTransaction.NORMAL_SALE;
        }
        InvoiceTransaction finalSelectedType = selectedType;
        this.doAsync(() -> {
            if (finalSelectedType == InvoiceTransaction.NORMAL) {
                return this.getCombinedInvoicesByTypeOnly(100, 0);
            }
            return this.invoiceService.getInvoicesByType(finalSelectedType, 100, 0);
        }).whenDone(firstPage -> {
            this.pagination.setPageCount(firstPage.getPageCount());
            this.pagination.setPageFactory(pageIndex -> {
                this.doAsync(() -> {
                    if (finalSelectedType == InvoiceTransaction.NORMAL) {
                        return this.getCombinedInvoicesByTypeOnly(100, (int)pageIndex);
                    }
                    return this.invoiceService.getInvoicesByType(finalSelectedType, 100, (int)pageIndex);
                }).whenDone(invoicePage -> this.populateInvoiceTable((Page<InvoiceView>)invoicePage));
                return new VBox();
            });
        });
    }

    @FXML
    private void searchInvoicesByDate() {
        LocalDate start = (LocalDate)this.startDate.getValue();
        LocalDate end = (LocalDate)this.endDate.getValue();
        InvoiceTransaction selectedType = (InvoiceTransaction)this.receiptTypeComboBox.getValue();
        if (start == null || end == null) {
            this.alertNoItemsFound();
            return;
        }
        Page<InvoiceView> page = selectedType == null || selectedType == InvoiceTransaction.NORMAL ? this.getCombinedInvoices(start, end, 100, 0) : this.invoiceService.getInvoicesByDateAndType(start, end, selectedType, 100, 0);
        ObservableList observableInvoices = FXCollections.observableArrayList(page.getData());
        this.invoiceTable.setItems(observableInvoices);
        int totalInvoices = page.getTotalCount();
        int pageCount = (int)Math.ceil((double)totalInvoices / 100.0);
        this.pagination.setPageCount(pageCount);
        this.pagination.setPageFactory(pageIndex -> {
            this.doAsync(() -> {
                if (selectedType == null || selectedType == InvoiceTransaction.NORMAL) {
                    return this.getCombinedInvoices(start, end, 100, (int)pageIndex);
                }
                return this.invoiceService.getInvoicesByDateAndType(start, end, selectedType, 100, (int)pageIndex);
            }).whenDone(invoicePage -> this.populateInvoiceTable((Page<InvoiceView>)invoicePage));
            return new VBox();
        });
    }

    private Page<InvoiceView> getInvoicesForPage(int pageIndex) {
        return this.invoiceService.getAllInvoices(100, pageIndex);
    }

    private void populateInvoiceTable(Page<InvoiceView> page) {
        this.invoiceTable.getItems().clear();
        this.invoiceTable.getItems().setAll(page.getData());
        if (this.invoiceTable.getItems().size() > 0) {
            this.invoiceTable.getSelectionModel().select(0);
            this.invoiceTable.scrollTo(0);
        }
    }

    @PostConstruct
    public void initView() {
        this.timeColumn.setCellValueFactory(v -> {
            LocalDateTime dateAndTime = ((InvoiceView)v.getValue()).getSdcDateTime();
            String formattedDate = dateAndTime.format(DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss"));
            return new SimpleStringProperty(formattedDate);
        });
        this.setDateField();
        this.initializeReceiptType();
        this.typeColumn.setCellValueFactory(v -> new SimpleStringProperty(((InvoiceView)v.getValue()).getType().getDescription()));
        this.priceColumn.setCellValueFactory(v -> {
            String priceString = ((InvoiceView)v.getValue()).getTotal();
            BigDecimal price = null;
            try {
                price = new BigDecimal(priceString);
            }
            catch (NumberFormatException e) {
                price = BigDecimal.ZERO;
            }
            DecimalFormat decimalFormat = new DecimalFormat("#,##0.00");
            String formattedPrice = decimalFormat.format(price);
            return new SimpleStringProperty(formattedPrice);
        });
        this.numberColumn.setCellValueFactory((Callback)new PropertyValueFactory("sdcNumber"));
        this.loadInvoicesByType();
        this.receiptTypeComboBox.setOnAction(event -> this.loadInvoicesByType());
        this.txtSearch.setOnKeyPressed(e -> {
            if (e.getCode() == KeyCode.ENTER) {
                if (this.txtSearch.getText().isEmpty()) {
                    this.loadInvoicesByType();
                } else {
                    this.searchInvoicesFull(this.txtSearch.getText());
                }
            }
        });
        this.invoiceTable.getSelectionModel().select(0);
        this.receiptTypeComboBox.valueProperty().addListener((obs, oldVal, newVal) -> this.searchInvoicesByDate());
    }

    private void setDateField() {
        this.startDate.setValue((Object)LocalDate.now());
        this.endDate.setValue((Object)LocalDate.now());
    }

    public void initializeReceiptType() {
        this.receiptTypeComboBox.getItems().addAll((Object[])InvoiceTransaction.getExtended());
        this.receiptTypeComboBox.setValue((Object)InvoiceTransaction.NORMAL_SALE);
    }

    private void searchInvoicesFull(String searchText) {
        if (searchText == null || searchText.trim().isEmpty()) {
            return;
        }
        Page<InvoiceView> page = this.invoiceService.searchInvoices(searchText, 100, 0);
        ObservableList observableInvoices = FXCollections.observableArrayList(page.getData());
        this.invoiceTable.setItems(observableInvoices);
        int totalInvoices = page.getTotalCount();
        int pageCount = (int)Math.ceil((double)totalInvoices / 100.0);
        this.pagination.setPageCount(pageCount);
        this.pagination.setPageFactory(pageIndex -> {
            if (pageIndex == 0) {
                this.populateInvoiceTable(page);
            } else {
                this.doAsync(() -> this.getInvoicesForPage((int)pageIndex)).whenDone(invoicePage -> this.populateInvoiceTable((Page<InvoiceView>)invoicePage));
            }
            return new VBox();
        });
        if (page.getTotalCount() == 0) {
            this.alertNoItemsFound();
        }
    }

    @FXML
    public void onSearchButton() {
        String searchText = this.txtSearch.getText();
        if (searchText.isEmpty()) {
            this.loadInvoicesByType();
            return;
        }
        this.searchInvoicesFull(searchText);
    }

    private void alertNoItemsFound() {
        this.uiCommands.showAlert().error().withTitle("Gre\u0161ka", new Object[0]).withMessage("Nema dostupnih artikala.", new Object[0]).execute();
    }

    @Action(order=2, id="action-edit", text="Storniranje Ra\u010duna", accelerator="F10", tooltip="Storniranje ra\u010duna")
    public void onChange(ActionEvent event) {
        this.selectedItem = (InvoiceView)this.invoiceTable.getSelectionModel().getSelectedItem();
        if (this.selectedItem == null) {
            return;
        }
        InvoiceTransaction transactionType = this.selectedItem.getType();
        if (transactionType.getDescription().contains("REFUNDACIJA")) {
            this.uiCommands.showAlert().error().withTitle("Gre\u0161ka", new Object[0]).withMessage("Ne mo\u017eete refundirati ra\u010dun koji je vec refundiran.", new Object[0]).execute();
            return;
        }
        this.loadView(InvoiceCancellationController.class).get(view -> this.uiCommands.displayContent(view).execute());
    }
}

