/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.controller;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.util.Callback;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.pos.controller.CancellationReceiptController;
import rs.tetrabyte.pos.model.view.InvoiceItemView;
import rs.tetrabyte.pos.model.view.InvoiceView;
import rs.tetrabyte.pos.service.InvoiceCancellationService;
import rs.tetrabyte.pos.service.InvoiceItemService;
import rs.tetrabyte.xcelerate.app.commands.UICommands;
import rs.tetrabyte.xcelerate.core.fxml.FXMLController;
import rs.tetrabyte.xcelerate.core.fxml.annotation.FXMLView;
import rs.tetrabyte.xcelerate.core.fxml.annotation.Input;
import rs.tetrabyte.xcelerate.core.fxml.annotation.Output;

@FXMLView(value="/fxml/InvoiceCancellationView.fxml")
public class InvoiceCancellationController
extends FXMLController {
    @FXML
    private TableView<InvoiceItemView> cancellationTable;
    @FXML
    private TableColumn<InvoiceItemView, Boolean> selectedColumn;
    @FXML
    private TableColumn<InvoiceItemView, String> idColumn;
    @FXML
    private TableColumn<InvoiceItemView, String> nameColumn;
    @FXML
    private TableColumn<InvoiceItemView, String> priceColumn;
    @FXML
    private TableColumn<InvoiceItemView, String> unitColumn;
    @FXML
    private TableColumn<InvoiceItemView, BigDecimal> qtyColumn;
    @FXML
    private TableColumn<InvoiceItemView, String> valueColumn;
    @FXML
    private DatePicker datePicker;
    @FXML
    private ComboBox<String> reasonComboBox;
    @FXML
    private CheckBox headerCheckBox;
    @FXML
    private Button editQtyButton;
    @FXML
    @Input
    private InvoiceView selectedItem;
    @Autowired
    private InvoiceCancellationService cancellationService;
    @Autowired
    private InvoiceItemService invoiceItemService;
    @Autowired
    private UICommands uiCommands;
    @FXML
    private Button receiptButton;
    private BigDecimal refundableQuantity;
    @Output(value="closeParent")
    private Runnable closeParent = () -> this.uiCommands.removeView((Node)this.getRootNode()).execute();

    @PostConstruct
    public void initView() {
        if (this.selectedItem == null) {
            return;
        }
        List<InvoiceItemView> items = this.invoiceItemService.getInvoiceItemsByInvoice(this.selectedItem);
        items.forEach(item -> {
            BigDecimal refunded = item.getRefundedQuantity() != null ? item.getRefundedQuantity() : BigDecimal.ZERO;
            BigDecimal refundable = item.getQuantity().subtract(refunded);
            item.setRefundableQuantity(refundable.max(BigDecimal.ZERO));
        });
        ObservableList observableItems = FXCollections.observableArrayList(items);
        this.cancellationTable.setItems(observableItems);
        this.selectedColumn.setCellValueFactory(cellData -> ((InvoiceItemView)cellData.getValue()).selectedProperty());
        this.selectedColumn.setCellFactory(CheckBoxTableCell.forTableColumn(this.selectedColumn));
        this.idColumn.setCellValueFactory((Callback)new PropertyValueFactory("uid"));
        this.nameColumn.setCellValueFactory((Callback)new PropertyValueFactory("shortName"));
        this.unitColumn.setCellValueFactory((Callback)new PropertyValueFactory("unit"));
        this.priceColumn.setCellValueFactory((Callback)new PropertyValueFactory("price"));
        this.qtyColumn.setCellValueFactory(cellData -> new SimpleObjectProperty((Object)((InvoiceItemView)cellData.getValue()).getRefundableQuantity()));
        this.valueColumn.setCellValueFactory(cellData -> {
            InvoiceItemView item = (InvoiceItemView)cellData.getValue();
            BigDecimal total = item.getPrice().multiply(item.getRefundableQuantity());
            return new SimpleStringProperty(total.setScale(2, RoundingMode.HALF_UP).toPlainString());
        });
        this.datePicker.setValue((Object)LocalDate.now());
        this.reasonComboBox.setItems(FXCollections.observableArrayList((Object[])new String[]{"Ra\u010dun sadr\u017ei gre\u0161ku", "Kupac je vratio robu"}));
        this.cancellationTable.getSelectionModel().selectFirst();
    }

    private List<InvoiceItemView> getSelectedItems() {
        if (this.cancellationTable.getItems() == null) {
            return new ArrayList<InvoiceItemView>();
        }
        return this.cancellationTable.getItems().stream().filter(InvoiceItemView::isSelected).collect(Collectors.toList());
    }

    @FXML
    private void selectAll() {
        boolean select = this.headerCheckBox.isSelected();
        this.cancellationTable.getItems().forEach(item -> item.setSelected(select));
        this.cancellationTable.refresh();
    }

    @FXML
    private void changeQuantityForSelectedItem() {
        InvoiceItemView selected = (InvoiceItemView)this.cancellationTable.getSelectionModel().getSelectedItem();
        if (selected == null) {
            this.uiCommands.showAlert().error().withTitle("Gre\u0161ka", new Object[0]).withMessage("Niste selektovali ni jednu stavku.", new Object[0]).execute();
            return;
        }
        BigDecimal maxRefundable = selected.getRefundableQuantity();
        TextInputDialog dialog = new TextInputDialog(maxRefundable.setScale(2, RoundingMode.HALF_UP).toPlainString());
        dialog.setTitle("Izmena koli\u010dine");
        dialog.setHeaderText("Unesite novu koli\u010dinu za selektovanu stavku");
        dialog.setContentText("Nova koli\u010dina (max. " + maxRefundable.toPlainString() + "):");
        dialog.initOwner(this.getRootNode().getScene().getWindow());
        dialog.showAndWait().ifPresent(input -> {
            try {
                BigDecimal newQty = new BigDecimal((String)input).setScale(2, RoundingMode.HALF_UP);
                if (newQty.compareTo(BigDecimal.ZERO) <= 0) {
                    this.uiCommands.showAlert().error().withTitle("Neva\u017ee\u0107i unos", new Object[0]).withMessage("Koli\u010dina mora biti ve\u0107a od 0.", new Object[0]).execute();
                    return;
                }
                if (newQty.compareTo(selected.getQuantity()) > 0) {
                    this.uiCommands.showAlert().error().withTitle("Neva\u017ee\u0107i unos", new Object[0]).withMessage("Koli\u010dina ne mo\u017ee biti ve\u0107a od " + selected.getQuantity().toPlainString(), new Object[0]).execute();
                    return;
                }
                selected.setRefundableQuantity(newQty);
                this.cancellationTable.refresh();
            }
            catch (NumberFormatException e) {
                this.uiCommands.showAlert().error().withTitle("Neva\u017ee\u0107i unos", new Object[0]).withMessage("Uneli ste neva\u017ee\u0107i broj.", new Object[0]).execute();
            }
        });
    }

    @FXML
    private void getReceipt() {
        List<InvoiceItemView> selectedItems = this.getSelectedItems();
        if (selectedItems.isEmpty()) {
            this.uiCommands.showAlert().error().withTitle("Gre\u0161ka", new Object[0]).withMessage("Niste izabrali nijednu stavku za storniranje.", new Object[0]).execute();
            return;
        }
        if (this.reasonComboBox.getValue() == null || ((String)this.reasonComboBox.getValue()).isBlank()) {
            this.uiCommands.showAlert().error().withTitle("Gre\u0161ka", new Object[0]).withMessage("Niste izabrali razlog storniranja.", new Object[0]).execute();
            return;
        }
        this.loadView(CancellationReceiptController.class).output(selectedItems).output(this.valueColumn).get(view -> this.uiCommands.displayContent(view).closable(false).execute());
    }
}

