/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.controller;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Optional;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.ListView;
import javafx.scene.control.Pagination;
import javafx.scene.control.TextArea;
import javafx.util.Callback;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.pos.controller.factory.DailyReportListCellFactory;
import rs.tetrabyte.pos.dao.Page;
import rs.tetrabyte.pos.model.view.DailyReportView;
import rs.tetrabyte.pos.service.DailyReportService;
import rs.tetrabyte.xcelerate.app.commands.UICommands;
import rs.tetrabyte.xcelerate.app.control.LockablePaneWrapper;
import rs.tetrabyte.xcelerate.core.fxml.FXMLController;
import rs.tetrabyte.xcelerate.core.fxml.annotation.FXMLView;

@FXMLView(value="/fxml/DailyReportView.fxml", wrappers={LockablePaneWrapper.class})
public class DailyReportViewController
extends FXMLController {
    @FXML
    private ListView<DailyReportView> listView;
    @FXML
    private TextArea textArea;
    @FXML
    private Pagination pagination;
    @FXML
    private ComboBox<String> cbUid;
    @FXML
    private DatePicker dpStart;
    @FXML
    private DatePicker dpEnd;
    private static final int PAGE_SIZE = 50;
    @Autowired
    private UICommands uiCommands;
    @Autowired
    private DailyReportService reportService;
    @Autowired
    private DailyReportListCellFactory listCellFactory;

    @PostConstruct
    private void init() {
        this.listView.setCellFactory((Callback)this.listCellFactory);
        this.listView.getSelectionModel().selectedItemProperty().addListener((o, ov, nv) -> {
            if (nv != null) {
                this.textArea.setText(nv.getData().getJournal());
            }
        });
        this.pagination.setPageFactory(pageNumber -> {
            this.refreshData((int)pageNumber);
            return null;
        });
        this.cbUid.getSelectionModel().selectedItemProperty().addListener((o, ov, nv) -> this.refreshData(0));
        this.dpStart.valueProperty().addListener((o, ov, nv) -> this.refreshData(0));
        this.dpEnd.valueProperty().addListener((o, ov, nv) -> this.refreshData(0));
        this.doAsync(() -> this.findReports(0)).whenDone(page -> {
            this.setPage((Page<DailyReportView>)page);
            this.pagination.setPageCount(page.getPageCount());
            this.doAsync(() -> this.reportService.findAllUids()).whenDone(uids -> {
                uids.add(0, "");
                this.cbUid.getItems().setAll((Collection)uids);
            });
        });
    }

    private Page<DailyReportView> findReports(int pageNumber) {
        String uid = (String)this.cbUid.getSelectionModel().getSelectedItem();
        LocalDateTime starDateTime = Optional.ofNullable((LocalDate)this.dpStart.getValue()).map(value -> value.atTime(0, 0, 0)).orElse(null);
        LocalDateTime endDateTime = Optional.ofNullable((LocalDate)this.dpEnd.getValue()).map(value -> value.atTime(23, 59, 59)).orElse(null);
        return this.reportService.findAll(uid, starDateTime, endDateTime, pageNumber, 50);
    }

    private void setPage(Page<DailyReportView> page) {
        this.listView.getItems().setAll(page.getData());
        if (this.listView.getItems().size() > 0) {
            this.listView.getSelectionModel().select(0);
        }
    }

    private void refreshData(int pageNumber) {
        this.doAsync(() -> this.findReports(pageNumber)).whenDone(page -> this.setPage((Page<DailyReportView>)page));
    }

    @FXML
    public void closeDay(ActionEvent event) {
        this.uiCommands.showAlert().confirm().withTitle("Kraj dana", new Object[0]).withMessage("Zatvarate dan?", new Object[0]).onConfirmed((EventHandler<Event>)((EventHandler)e -> this.doAsync(() -> this.reportService.closeDay()).whenDone(report -> {
            if (report != null) {
                this.refreshData(0);
            }
            this.doAsync(() -> this.reportService.findAllUids()).whenDone(uids -> this.cbUid.getItems().setAll((Collection)uids));
        }))).execute();
    }

    @FXML
    public void close(ActionEvent event) {
        this.uiCommands.removeView((Node)this.getRootNode()).execute();
    }
}

