/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.controller;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableColumn;
import javafx.scene.input.KeyCode;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.pos.builder.controls.FormattedTextField;
import rs.tetrabyte.pos.model.entity.PaymentType;
import rs.tetrabyte.pos.model.view.InvoiceItemView;
import rs.tetrabyte.pos.model.view.InvoiceView;
import rs.tetrabyte.pos.sdc.InvoiceTransaction;
import rs.tetrabyte.pos.sdc.SDCException;
import rs.tetrabyte.pos.service.InvoiceService;
import rs.tetrabyte.pos.service.SDCService;
import rs.tetrabyte.xcelerate.app.commands.UICommands;
import rs.tetrabyte.xcelerate.core.fxml.FXMLController;
import rs.tetrabyte.xcelerate.core.fxml.annotation.FXMLView;
import rs.tetrabyte.xcelerate.core.fxml.annotation.Input;
import rs.tetrabyte.xcelerate.core.task.AbstractTask;
import rs.tetrabyte.xcelerate.core.task.TaskFactory;

@FXMLView(value="/fxml/CancellationReceipt.fxml")
public class CancellationReceiptController
extends FXMLController {
    @FXML
    private FormattedTextField<BigDecimal> amountField;
    @FXML
    private FormattedTextField<BigDecimal> otherField;
    @FXML
    private FormattedTextField<BigDecimal> instantField;
    @FXML
    private FormattedTextField<BigDecimal> couponField;
    @FXML
    private FormattedTextField<BigDecimal> transferField;
    @FXML
    private FormattedTextField<BigDecimal> cardField;
    @FXML
    private FormattedTextField<BigDecimal> checkField;
    @FXML
    private FormattedTextField<BigDecimal> cashField;
    @FXML
    private ComboBox<InvoiceTransaction> receiptType;
    @Input
    private List<InvoiceItemView> checkedItems;
    @Input
    private InvoiceView selectedItem;
    @Input
    private TableColumn<InvoiceItemView, String> valueColumn;
    @Autowired
    private UICommands commands;
    @Autowired
    private InvoiceService invoiceService;
    @Autowired
    private TaskFactory taskFactory;
    @Autowired
    private SDCService sdcService;
    @Autowired
    private UICommands uiCommands;
    private BigDecimal totalValue;
    @Input(value="closeParent")
    private Runnable closeParent;

    private void setDecimalFormat() {
        this.totalValue = this.calculateTotalValueFromColumn();
        this.amountField.setValue(this.totalValue);
    }

    private BigDecimal calculateTotalValueFromColumn() {
        BigDecimal total = BigDecimal.ZERO;
        for (InvoiceItemView item : this.checkedItems) {
            BigDecimal itemValue = item.getPrice().multiply(item.getQuantity());
            total = total.add(itemValue);
        }
        return total;
    }

    @PostConstruct
    public void postConstruct() {
        this.setDecimalFormat();
        this.setupKeyListeners();
        this.initFieldListeners();
    }

    private void initFieldListeners() {
        this.cashField.setValue(this.totalValue);
    }

    @FXML
    private void onExit() {
        this.commands.removeView((Node)this.getRootNode()).execute();
    }

    private void setupKeyListeners() {
        this.cashField.setOnKeyReleased(event -> {
            if (event.getCode() == KeyCode.UP) {
                this.cardField.setValue(this.cashField.getValue());
                this.cashField.clear();
                this.cashField.setValue(BigDecimal.ZERO);
                this.cardField.requestFocus();
                event.consume();
            }
        });
        this.cardField.setOnKeyReleased(event -> {
            if (event.getCode() == KeyCode.UP) {
                this.checkField.setValue(this.cardField.getValue());
                this.cardField.clear();
                this.cardField.setValue(BigDecimal.ZERO);
                this.checkField.requestFocus();
                event.consume();
            } else if (event.getCode() == KeyCode.DOWN) {
                this.cashField.setValue(this.cardField.getValue());
                this.cardField.clear();
                this.cardField.setValue(BigDecimal.ZERO);
                this.cashField.requestFocus();
                event.consume();
            }
        });
        this.checkField.setOnKeyReleased(event -> {
            if (event.getCode() == KeyCode.UP) {
                this.transferField.setValue(this.checkField.getValue());
                this.checkField.clear();
                this.checkField.setValue(BigDecimal.ZERO);
                this.transferField.requestFocus();
                event.consume();
            } else if (event.getCode() == KeyCode.DOWN) {
                this.cardField.setValue(this.checkField.getValue());
                this.checkField.clear();
                this.checkField.setValue(BigDecimal.ZERO);
                this.cardField.requestFocus();
                event.consume();
            }
        });
        this.couponField.setOnKeyReleased(event -> {
            if (event.getCode() == KeyCode.UP) {
                this.instantField.setValue(this.couponField.getValue());
                this.couponField.clear();
                this.couponField.setValue(BigDecimal.ZERO);
                this.instantField.requestFocus();
                event.consume();
            } else if (event.getCode() == KeyCode.DOWN) {
                this.transferField.setValue(this.couponField.getValue());
                this.couponField.clear();
                this.couponField.setValue(BigDecimal.ZERO);
                this.transferField.requestFocus();
                event.consume();
            }
        });
        this.instantField.setOnKeyReleased(event -> {
            if (event.getCode() == KeyCode.UP) {
                this.otherField.setValue(this.instantField.getValue());
                this.instantField.clear();
                this.instantField.setValue(BigDecimal.ZERO);
                this.otherField.requestFocus();
                event.consume();
            } else if (event.getCode() == KeyCode.DOWN) {
                this.couponField.setValue(this.instantField.getValue());
                this.instantField.clear();
                this.instantField.setValue(BigDecimal.ZERO);
                this.couponField.requestFocus();
                event.consume();
            }
        });
        this.transferField.setOnKeyReleased(event -> {
            if (event.getCode() == KeyCode.UP) {
                this.couponField.setValue(this.transferField.getValue());
                this.transferField.clear();
                this.transferField.setValue(BigDecimal.ZERO);
                this.couponField.requestFocus();
                event.consume();
            } else if (event.getCode() == KeyCode.DOWN) {
                this.checkField.setValue(this.transferField.getValue());
                this.transferField.clear();
                this.transferField.setValue(BigDecimal.ZERO);
                this.checkField.requestFocus();
                event.consume();
            }
        });
        this.otherField.setOnKeyReleased(event -> {
            if (event.getCode() == KeyCode.UP) {
                this.cashField.setValue(this.otherField.getValue());
                this.otherField.clear();
                this.otherField.setValue(BigDecimal.ZERO);
                this.cashField.requestFocus();
                event.consume();
            } else if (event.getCode() == KeyCode.DOWN) {
                this.otherField.setValue(this.otherField.getValue());
                this.otherField.clear();
                this.otherField.setValue(BigDecimal.ZERO);
                this.otherField.requestFocus();
                event.consume();
            }
        });
    }

    private InvoiceView buildInvoice(InvoiceTransaction type) {
        InvoiceView invoice = new InvoiceView();
        invoice.setId(UUID.randomUUID());
        invoice.setType(type);
        invoice.setCashier("Ime kasira");
        invoice.setReferentDocumentDT(this.selectedItem.getSdcDateTime());
        invoice.setReferentDocumentNumber(this.selectedItem.getSdcNumber());
        ArrayList<InvoiceItemView> copiedItems = new ArrayList<InvoiceItemView>();
        for (InvoiceItemView item : this.checkedItems) {
            copiedItems.add(new InvoiceItemView());
        }
        invoice.setItems(copiedItems);
        invoice.addNonZeroPayment(PaymentType.Cash, this.cashField.getValue());
        invoice.addNonZeroPayment(PaymentType.Card, this.cardField.getValue());
        invoice.addNonZeroPayment(PaymentType.Check, this.checkField.getValue());
        invoice.addNonZeroPayment(PaymentType.WireTransfer, this.transferField.getValue());
        invoice.addNonZeroPayment(PaymentType.Voucher, this.couponField.getValue());
        invoice.addNonZeroPayment(PaymentType.MobileMoney, this.instantField.getValue());
        invoice.addNonZeroPayment(PaymentType.Other, this.otherField.getValue());
        return invoice;
    }

    @FXML
    private void saveReceipt() throws SDCException {
        this.sdcService.verifyPin(() -> this.onSave());
    }

    private void onSave() {
        InvoiceView refundInvoice = this.buildInvoice(this.selectedItem.getType().toRefund());
        ((AbstractTask)((Object)((AbstractTask)((Object)this.taskFactory.createTask(() -> {
            try {
                this.invoiceService.addInvoice(refundInvoice);
                InvoiceView copyRefundInvoice = this.buildInvoice(InvoiceTransaction.COPY_REFUND);
                this.invoiceService.addInvoice(copyRefundInvoice);
                return null;
            }
            catch (SDCException e) {
                throw new RuntimeException(e);
            }
        }).ifFailed(e -> this.uiCommands.showAlert().error().withTitle("Gre\u0161ka pri \u010duvanju ra\u010duna", new Object[0]).withMessage(e.getCause().getMessage(), new Object[0]).execute()))).whenDone(a -> {
            this.cancelReceipt();
            this.closeParent.run();
        }))).execute();
    }

    @FXML
    public void cancelReceipt() {
        this.uiCommands.removeView((Node)this.getRootNode()).execute();
    }
}

