/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.builder.controls;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.control.DatePicker;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Builder;
import javafx.util.StringConverter;

public class DateTimePicker
extends DatePicker
implements Builder<DatePicker> {
    private final ObjectProperty<LocalDateTime> dateTimeValue = new SimpleObjectProperty((Object)LocalDateTime.now());
    private DateTimeFormatter formatter;
    private DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy. HH:mm:ss");
    private DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy.");

    private void simulateEnterPressed() {
        this.getEditor().fireEvent((Event)new KeyEvent((Object)this.getEditor(), (EventTarget)this.getEditor(), KeyEvent.KEY_PRESSED, "", "", KeyCode.ENTER, false, false, false, false));
    }

    public ObjectProperty<LocalDateTime> dateTimeValueProperty() {
        return this.dateTimeValue;
    }

    public DatePicker build() {
        this.formatter = "date-time-picker".equals(this.getId()) ? this.dateTimeFormatter : this.dateFormatter;
        this.setConverter((StringConverter)new StringConverter<LocalDate>(){

            public String toString(LocalDate value) {
                return DateTimePicker.this.dateTimeValue.get() != null ? ((LocalDateTime)DateTimePicker.this.dateTimeValue.get()).format(DateTimePicker.this.formatter) : "";
            }

            public LocalDate fromString(String value) {
                if (value == null || value.isEmpty()) {
                    DateTimePicker.this.dateTimeValue.set(null);
                    return null;
                }
                if (DateTimePicker.this.formatter == DateTimePicker.this.dateTimeFormatter) {
                    DateTimePicker.this.dateTimeValue.set((Object)LocalDateTime.parse(value, DateTimePicker.this.formatter));
                } else {
                    DateTimePicker.this.dateTimeValue.set((Object)LocalDate.parse(value, DateTimePicker.this.formatter).atTime(0, 0));
                }
                return ((LocalDateTime)DateTimePicker.this.dateTimeValue.get()).toLocalDate();
            }
        });
        this.valueProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue == null) {
                this.dateTimeValue.set(null);
            } else if (this.dateTimeValue.get() == null) {
                this.dateTimeValue.set((Object)LocalDateTime.of(newValue, LocalTime.now()));
            } else {
                LocalTime time = ((LocalDateTime)this.dateTimeValue.get()).toLocalTime();
                this.dateTimeValue.set((Object)LocalDateTime.of(newValue, time));
            }
        });
        this.dateTimeValue.addListener((observable, oldValue, newValue) -> this.setValue(newValue != null ? newValue.toLocalDate() : null));
        this.getEditor().focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.simulateEnterPressed();
            }
        });
        return this;
    }
}

