/*
 * Decompiled with CFR 0.152.
 */
package org.javaldap.btree;

import org.javaldap.btree.KeyNode;

class BTNode {
    int order = 0;
    int nKey = 0;
    KeyNode[] kArray;
    BTNode[] btnArray;
    boolean isLeaf;
    BTNode parent;

    BTNode(int order, BTNode parent) {
        this.order = order;
        this.parent = parent;
        this.kArray = new KeyNode[2 * order - 1];
        this.btnArray = new BTNode[2 * order];
        this.isLeaf = true;
    }

    KeyNode extractKeyNode(int keyIndex) {
        KeyNode tmpKeyNode = this.getKeyNode(keyIndex);
        int i = keyIndex;
        while (i < this.nKey) {
            this.kArray[i] = this.kArray[i + 1];
            if (!this.isLeaf) {
                this.btnArray[i] = this.btnArray[i + 1];
            }
            ++i;
        }
        --this.nKey;
        return tmpKeyNode;
    }

    BTNode getBTNode(int keyIndex) {
        return this.btnArray[keyIndex];
    }

    KeyNode getKeyNode(int keyIndex) {
        return this.kArray[keyIndex];
    }

    void insert(KeyNode keyNode) {
        if (this.nKey == 0) {
            ++this.nKey;
            this.kArray[0] = keyNode;
        } else {
            int pos = 0;
            while (keyNode.getKey().compareTo(this.kArray[pos].getKey()) > 0) {
                if (++pos == this.nKey) break;
            }
            if (this.nKey == this.order * 2 - 1) {
                BTNode right = this.split();
                if (pos > this.order - 1) {
                    right.insert(keyNode);
                } else {
                    if (pos != this.nKey) {
                        this.shift(pos);
                    } else {
                        ++this.nKey;
                    }
                    this.kArray[pos] = keyNode;
                }
            } else {
                if (pos != this.nKey) {
                    this.shift(pos);
                } else {
                    ++this.nKey;
                }
                this.kArray[pos] = keyNode;
            }
        }
    }

    void mergeWithBTNode() {
        BTNode parentBTNode = this.parent;
        int parentIndex = 0;
        while (parentBTNode.getBTNode(parentIndex) != this) {
            ++parentIndex;
        }
        BTNode mergeBTNode = parentIndex > 1 ? this.parent.getBTNode(parentIndex - 1) : this.parent.getBTNode(parentIndex + 1);
        if (mergeBTNode != null) {
            this.kArray[this.nKey - 1] = parentBTNode.getKeyNode(parentIndex);
            int i = this.nKey;
            int j = 0;
            while (j < mergeBTNode.nKey) {
                this.kArray[i] = mergeBTNode.getKeyNode(j);
                ++this.nKey;
                ++i;
                ++j;
            }
            i = parentIndex;
            while (i < this.nKey) {
                parentBTNode.kArray[i] = parentBTNode.kArray[i + 1];
                parentBTNode.btnArray[i + 1] = parentBTNode.btnArray[i + 2];
                ++i;
            }
            parentBTNode.kArray[i] = null;
            parentBTNode.btnArray[i + 1] = null;
            --parentBTNode.nKey;
        }
    }

    void shift(int startPos) {
        int i = this.nKey;
        while (i > startPos) {
            this.kArray[i] = this.kArray[i - 1];
            if (!this.isLeaf) {
                this.btnArray[i + 1] = this.btnArray[i];
            }
            --i;
        }
        ++this.nKey;
    }

    BTNode split() {
        if (this.nKey == this.order * 2 - 1) {
            BTNode right = null;
            if (this.parent == null) {
                BTNode left = new BTNode(this.order, this);
                right = new BTNode(this.order, this);
                int i = 0;
                while (i < this.order - 1) {
                    left.kArray[i] = this.kArray[i];
                    right.kArray[i] = this.kArray[this.order + i];
                    ++i;
                }
                if (!this.isLeaf) {
                    i = 0;
                    while (i < this.order) {
                        left.btnArray[i] = this.btnArray[i];
                        left.btnArray[i].parent = left;
                        right.btnArray[i] = this.btnArray[this.order + i];
                        right.btnArray[i].parent = right;
                        ++i;
                    }
                    left.isLeaf = false;
                    right.isLeaf = false;
                } else {
                    this.isLeaf = false;
                }
                this.kArray[0] = this.kArray[this.order - 1];
                this.nKey = 1;
                left.nKey = this.order - 1;
                right.nKey = this.order - 1;
                i = 1;
                while (i < this.order * 2 - 1) {
                    this.kArray[i] = null;
                    this.btnArray[i + 1] = null;
                    ++i;
                }
                this.btnArray[0] = left;
                this.btnArray[1] = right;
            } else {
                if (this.parent.nKey == this.order * 2 - 1) {
                    this.parent.split();
                }
                int pos = 0;
                while (this.kArray[this.order - 1].getKey().compareTo(this.parent.kArray[pos].getKey()) > 0) {
                    if (++pos == this.parent.nKey) break;
                }
                this.parent.shift(pos);
                this.parent.kArray[pos] = this.kArray[this.order - 1];
                right = new BTNode(this.order, this.parent);
                int i = 0;
                while (i < this.order - 1) {
                    right.kArray[i] = this.kArray[this.order + i];
                    ++i;
                }
                if (!this.isLeaf) {
                    i = 0;
                    while (i < this.order) {
                        right.btnArray[i] = this.btnArray[this.order + i];
                        right.btnArray[i].parent = right;
                        ++i;
                    }
                    right.isLeaf = false;
                }
                right.nKey = this.order - 1;
                this.nKey = this.order - 1;
                int u = 0;
                while (u < this.order - 1) {
                    this.kArray[this.order - 1 + u] = null;
                    this.btnArray[this.order + u] = null;
                    ++u;
                }
                this.parent.btnArray[pos] = this;
                this.parent.btnArray[pos + 1] = right;
            }
            return right;
        }
        return null;
    }
}

